/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.model.snapshots.Exemplars;
import java.time.Duration;
import java.util.Arrays;

class PrometheusHistogram
extends TimeWindowFixedBoundaryHistogram {
    @Nullable
    private final ExemplarSampler exemplarSampler;

    PrometheusHistogram(Clock clock, DistributionStatisticConfig config, @Nullable ExemplarSamplerFactory exemplarSamplerFactory) {
        super(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(config), true);
        if (exemplarSamplerFactory != null) {
            double[] buckets = this.getBuckets();
            if (buckets[buckets.length - 1] != Double.POSITIVE_INFINITY) {
                buckets = Arrays.copyOf(buckets, buckets.length + 1);
                buckets[buckets.length - 1] = Double.POSITIVE_INFINITY;
            }
            this.exemplarSampler = exemplarSamplerFactory.createExemplarSampler(buckets);
        } else {
            this.exemplarSampler = null;
        }
    }

    public void recordDouble(double value) {
        super.recordDouble(value);
        if (this.exemplarSampler != null) {
            this.exemplarSampler.observe(value);
        }
    }

    public void recordLong(long value) {
        super.recordLong(value);
        if (this.exemplarSampler != null) {
            this.exemplarSampler.observe((double)value);
        }
    }

    Exemplars exemplars() {
        return this.exemplarSampler != null ? this.exemplarSampler.collect() : Exemplars.EMPTY;
    }
}

