/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.baggage.BaggageField;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageInScope;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BraveBaggageManager
implements Closeable,
BaggageManager {
    private static final Map<String, Baggage> CACHE = new ConcurrentHashMap<String, Baggage>();

    public Map<String, String> getAllBaggage() {
        return BaggageField.getAllValues();
    }

    public Baggage getBaggage(String name) {
        return this.createBaggage(name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        BaggageField baggageField = BaggageField.getByName((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext), (String)name);
        if (baggageField == null) {
            return null;
        }
        return new BraveBaggageInScope(baggageField);
    }

    public Baggage createBaggage(String name) {
        return CACHE.computeIfAbsent(name, s -> new BraveBaggageInScope(BaggageField.create((String)s)));
    }

    public Baggage createBaggage(String name, String value) {
        return this.createBaggage(name).set(value);
    }

    @Override
    public void close() {
        CACHE.clear();
    }
}

