/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.sampler;

import brave.sampler.Sampler;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ProbabilityBasedSampler
extends Sampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final BitSet sampleDecisions;
    private final Supplier<Float> probability;

    public ProbabilityBasedSampler(Supplier<Float> probability) {
        if (probability == null) {
            throw new IllegalArgumentException("probability property is required for ProbabilityBasedSampler");
        }
        this.probability = probability;
        int outOf100 = (int)(probability.get().floatValue() * 100.0f);
        this.sampleDecisions = ProbabilityBasedSampler.randomBitSet(100, outOf100, new Random());
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSampled(long traceId) {
        if (this.probability.get().floatValue() == 0.0f) {
            return false;
        }
        if (this.probability.get().floatValue() == 1.0f) {
            return true;
        }
        ProbabilityBasedSampler probabilityBasedSampler = this;
        synchronized (probabilityBasedSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 99) {
                this.counter.set(0);
            }
            return result;
        }
    }
}

