/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;

public class OtelTraceContextBuilder
implements TraceContext.Builder {
    private String traceId;
    private String parentId;
    private String spanId;
    @Nullable
    private Boolean sampled;

    public TraceContext.Builder traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public TraceContext.Builder parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public TraceContext.Builder spanId(String spanId) {
        this.spanId = spanId;
        return this;
    }

    public TraceContext.Builder sampled(@Nullable Boolean sampled) {
        this.sampled = sampled;
        return this;
    }

    public TraceContext build() {
        boolean actualSampled;
        boolean bl = actualSampled = this.sampled != null && this.sampled != false;
        if (StringUtils.isNotEmpty((String)this.parentId)) {
            return new OtelTraceContext(SpanContext.createFromRemoteParent((String)this.traceId, (String)this.spanId, (TraceFlags)(actualSampled ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null){

                @Override
                public String parentId() {
                    return OtelTraceContextBuilder.this.parentId;
                }

                @Override
                public Boolean sampled() {
                    return OtelTraceContextBuilder.this.sampled;
                }
            };
        }
        return new OtelTraceContext(SpanContext.create((String)this.traceId, (String)this.spanId, (TraceFlags)(actualSampled ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault()), null){

            @Override
            public Boolean sampled() {
                return OtelTraceContextBuilder.this.sampled;
            }
        };
    }
}

