/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.annotations;

import io.mockk.MockKException;
import io.mockk.impl.annotations.InjectionHelpers;
import io.mockk.impl.annotations.InjectionLookupType;
import io.mockk.impl.annotations.MockInjector;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0010\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u001c\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0002J,\u0010\u0017\u001a\u00020\u00062\u0016\u0010\u0018\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00192\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010 H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001J\u0016\u0010&\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(H\u0002J\u0018\u0010)\u001a\u00020\u001b\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0\u0014H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006,"}, d2={"Lio/mockk/impl/annotations/MockInjector;", "", "mockHolder", "lookupType", "Lio/mockk/impl/annotations/InjectionLookupType;", "injectImmutable", "", "overrideValues", "(Ljava/lang/Object;Lio/mockk/impl/annotations/InjectionLookupType;ZZ)V", "getInjectImmutable", "()Z", "getLookupType", "()Lio/mockk/impl/annotations/InjectionLookupType;", "getMockHolder", "()Ljava/lang/Object;", "getOverrideValues", "constructorInjection", "type", "Lkotlin/reflect/KClass;", "findMatchingConstructor", "Lkotlin/reflect/KFunction;", "injectViaConstructor", "firstMatching", "isMatchingType", "it", "Lkotlin/reflect/KProperty1;", "lookupToStr", "", "param", "Lkotlin/reflect/KParameter;", "lookupValueByName", "name", "Lkotlin/reflect/KClassifier;", "lookupValueByType", "matchParameter", "propertiesInjection", "", "instance", "tryMatchingParameters", "parameters", "", "constructorToStr", "R", "Companion", "mockk"})
@SourceDebugExtension(value={"SMAP\nMockInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockInjector.kt\nio/mockk/impl/annotations/MockInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1863#2,2:132\n1797#2,2:134\n1799#2:137\n295#2,2:138\n1734#2,3:140\n295#2,2:143\n295#2,2:145\n1#3:136\n*S KotlinDebug\n*F\n+ 1 MockInjector.kt\nio/mockk/impl/annotations/MockInjector\n*L\n33#1:132,2\n55#1:134,2\n55#1:137\n65#1:138,2\n75#1:140,3\n89#1:143,2\n99#1:145,2\n*E\n"})
public final class MockInjector {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Object mockHolder;
    @NotNull
    private final InjectionLookupType lookupType;
    private final boolean injectImmutable;
    private final boolean overrideValues;
    @NotNull
    private static final Comparator<KFunction<Object>> sortCriteria;

    public MockInjector(@NotNull Object mockHolder, @NotNull InjectionLookupType lookupType, boolean injectImmutable, boolean overrideValues) {
        Intrinsics.checkNotNullParameter((Object)mockHolder, (String)"mockHolder");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupType), (String)"lookupType");
        this.mockHolder = mockHolder;
        this.lookupType = lookupType;
        this.injectImmutable = injectImmutable;
        this.overrideValues = overrideValues;
    }

    @NotNull
    public final Object getMockHolder() {
        return this.mockHolder;
    }

    @NotNull
    public final InjectionLookupType getLookupType() {
        return this.lookupType;
    }

    public final boolean getInjectImmutable() {
        return this.injectImmutable;
    }

    public final boolean getOverrideValues() {
        return this.overrideValues;
    }

    @NotNull
    public final Object constructorInjection(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        KFunction<Object> kFunction = this.findMatchingConstructor(type);
        if (kFunction == null) {
            throw new MockKException("No matching constructors found:\n" + CollectionsKt.joinToString$default((Iterable)type.getConstructors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<KFunction<? extends Object>, CharSequence>(this){
                final /* synthetic */ MockInjector this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CharSequence invoke(KFunction<? extends Object> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return MockInjector.access$constructorToStr(this.this$0, it);
                }
            }), (int)30, null), null, 2, null);
        }
        KFunction<Object> firstMatching2 = kFunction;
        return this.injectViaConstructor(firstMatching2);
    }

    public final void propertiesInjection(@NotNull Object instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Iterable $this$forEach$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(instance.getClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            KProperty1 property = (KProperty1)element$iv;
            boolean bl = false;
            boolean isMutable = property instanceof KMutableProperty1;
            if (!this.injectImmutable && !isMutable || !this.overrideValues && InjectionHelpers.INSTANCE.getAnyIfLateNull(property, instance) != null || (object = this.lookupValueByName(property.getName(), property.getReturnType().getClassifier())) == null && (object = this.lookupValueByType(property.getReturnType().getClassifier())) == null) continue;
            Object newValue = object;
            if (this.injectImmutable && !isMutable) {
                InjectionHelpers.INSTANCE.setImmutableAny(property, instance, newValue);
                continue;
            }
            Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty1<*, *>");
            InjectionHelpers.INSTANCE.setAny((KMutableProperty1)property, instance, newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object injectViaConstructor(KFunction<? extends Object> firstMatching2) {
        void $this$fold$iv;
        Iterable iterable = KCallables.getValueParameters((KCallable)((KCallable)firstMatching2));
        Map initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void cur;
            Map map;
            KParameter kParameter = (KParameter)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            Map $this$injectViaConstructor_u24lambda_u243_u24lambda_u242 = map = acc;
            boolean bl2 = false;
            if (this.matchParameter((KParameter)cur) != null) {
                Object it;
                boolean bl3 = false;
                $this$injectViaConstructor_u24lambda_u243_u24lambda_u242.put(cur, it);
            }
            accumulator$iv = map;
        }
        Map it = accumulator$iv;
        boolean bl = false;
        return firstMatching2.callBy(it);
    }

    private final KFunction<Object> findMatchingConstructor(KClass<?> type) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)type.getConstructors(), sortCriteria);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KFunction it = (KFunction)element$iv;
                boolean bl = false;
                if (!this.tryMatchingParameters(KCallables.getValueParameters((KCallable)((KCallable)it)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Object matchParameter(KParameter param) {
        Object object = this.lookupValueByName(param.getName(), param.getType().getClassifier());
        if (object == null && (object = this.lookupValueByType(param.getType().getClassifier())) == null) {
            if (param.isOptional()) {
                object = null;
            } else {
                throw new MockKException("Parameter unmatched: " + param, null, 2, null);
            }
        }
        return object;
    }

    private final boolean tryMatchingParameters(List<? extends KParameter> parameters) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = parameters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KParameter param = (KParameter)element$iv;
                    boolean bl2 = false;
                    if (this.lookupValueByName(param.getName(), param.getType().getClassifier()) != null || this.lookupValueByType(param.getType().getClassifier()) != null || param.isOptional()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Object lookupValueByName(String name, KClassifier type) {
        Object v0;
        block5: {
            void $this$firstOrNull$iv;
            if (name == null) {
                return null;
            }
            if (type == null) {
                return null;
            }
            if (!(type instanceof KClass)) {
                return null;
            }
            if (!this.lookupType.getByName()) {
                return null;
            }
            Iterable iterable = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(this.mockHolder.getClass()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KProperty1 it = (KProperty1)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && this.isMatchingType((KProperty1<? extends Object, ? extends Object>)it, (KClass)type))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        KProperty1 kProperty1 = v0;
        return kProperty1 != null ? InjectionHelpers.INSTANCE.getAnyIfLateNull(kProperty1, this.mockHolder) : null;
    }

    private final Object lookupValueByType(KClassifier type) {
        Object v0;
        block4: {
            if (type == null) {
                return null;
            }
            if (!(type instanceof KClass)) {
                return null;
            }
            if (!this.lookupType.getByType()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(this.mockHolder.getClass()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KProperty1 it = (KProperty1)element$iv;
                boolean bl = false;
                if (!this.isMatchingType((KProperty1<? extends Object, ? extends Object>)it, (KClass)type)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        KProperty1 kProperty1 = v0;
        return kProperty1 != null ? InjectionHelpers.INSTANCE.getAnyIfLateNull(kProperty1, this.mockHolder) : null;
    }

    private final boolean isMatchingType(KProperty1<? extends Object, ? extends Object> it, KClass<?> type) {
        KClassifier propertyType = it.getReturnType().getClassifier();
        return propertyType instanceof KClass ? KClasses.isSubclassOf((KClass)((KClass)propertyType), type) : false;
    }

    private final <R> String constructorToStr(KFunction<? extends R> $this$constructorToStr) {
        String joinedParameters2 = CollectionsKt.joinToString$default((Iterable)$this$constructorToStr.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<KParameter, CharSequence>(this){
            final /* synthetic */ MockInjector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CharSequence invoke(KParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                StringBuilder stringBuilder = new StringBuilder();
                String string = it.getName();
                if (string == null) {
                    string = "<noname arg.>";
                }
                return stringBuilder.append(string).append(" : ").append(it.getType()).append(" = ").append(MockInjector.access$lookupToStr(this.this$0, it)).toString();
            }
        }), (int)30, null);
        return "constructor(" + joinedParameters2 + ')';
    }

    private final String lookupToStr(KParameter param) {
        Object object = this.lookupValueByName(param.getName(), param.getType().getClassifier());
        if (object == null && (object = this.lookupValueByType(param.getType().getClassifier())) == null) {
            object = "<not able to lookup>";
        }
        return object.toString();
    }

    public static final /* synthetic */ String access$constructorToStr(MockInjector $this, KFunction $receiver) {
        return $this.constructorToStr($receiver);
    }

    public static final /* synthetic */ String access$lookupToStr(MockInjector $this, KParameter param) {
        return $this.lookupToStr(param);
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.sortCriteria.1.INSTANCE, Companion.sortCriteria.2.INSTANCE};
        sortCriteria = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R*\u0010\u0003\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/mockk/impl/annotations/MockInjector$Companion;", "", "()V", "sortCriteria", "Ljava/util/Comparator;", "Lkotlin/reflect/KFunction;", "Lkotlin/Comparator;", "mockk"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

