/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.client;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.lra.annotation.CompensatorStatus;
import org.eclipse.microprofile.lra.client.GenericLRAException;
import org.eclipse.microprofile.lra.client.LRAInfo;

public interface LRAClient {
    public static final String LRA_HTTP_HEADER = "Long-Running-Action";
    public static final String LRA_HTTP_RECOVERY_HEADER = "Long-Running-Action-Recovery";
    public static final String LRA_COORDINATOR_HOST_KEY = "lra.http.host";
    public static final String LRA_COORDINATOR_PORT_KEY = "lra.http.port";
    public static final String LRA_COORDINATOR_PATH_KEY = "lra.coordinator.path";
    public static final String LRA_RECOVERY_HOST_KEY = "lra.http.recovery.host";
    public static final String LRA_RECOVERY_PORT_KEY = "lra.http.recovery.port";
    public static final String LRA_RECOVERY_PATH_KEY = "lra.coordinator.recovery.path";

    public void setCoordinatorURI(URI var1);

    public void setRecoveryCoordinatorURI(URI var1);

    public void close();

    public URL startLRA(URL var1, String var2, Long var3, TimeUnit var4) throws GenericLRAException;

    public URL startLRA(String var1, Long var2, TimeUnit var3) throws GenericLRAException;

    public String cancelLRA(URL var1) throws GenericLRAException;

    public String closeLRA(URL var1) throws GenericLRAException;

    public List<LRAInfo> getActiveLRAs() throws GenericLRAException;

    public List<LRAInfo> getAllLRAs() throws GenericLRAException;

    public List<LRAInfo> getRecoveringLRAs() throws GenericLRAException;

    public Optional<CompensatorStatus> getStatus(URL var1) throws GenericLRAException;

    public Boolean isActiveLRA(URL var1) throws GenericLRAException;

    public Boolean isCompensatedLRA(URL var1) throws GenericLRAException;

    public Boolean isCompletedLRA(URL var1) throws GenericLRAException;

    public String joinLRA(URL var1, Long var2, URL var3, URL var4, URL var5, URL var6, URL var7, String var8) throws GenericLRAException;

    public String joinLRA(URL var1, Class<?> var2, URI var3, String var4) throws GenericLRAException;

    public URL updateCompensator(URL var1, URL var2, URL var3, URL var4, URL var5, String var6) throws GenericLRAException;

    public void leaveLRA(URL var1, String var2) throws GenericLRAException;

    public void renewTimeLimit(URL var1, long var2, TimeUnit var4);

    public URL getCurrent();

    public void setCurrentLRA(URL var1);
}

