/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.lra.tck.TckTests;

class TckMethodResult {
    private String testName;
    private Function<TckTests, String> testMethod;
    private boolean passed;
    private boolean ran;
    private boolean verbose;
    private String result;
    private Throwable failureReason;

    TckMethodResult(String testName, Function<TckTests, String> testMethod, boolean verbose) {
        this.testName = testName;
        this.testMethod = testMethod;
        this.verbose = verbose;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public boolean isRan() {
        return this.ran;
    }

    public String getResult() {
        return this.result;
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TckMethodResult tckMethodResult = (TckMethodResult)o;
        return Objects.equals(this.testName, tckMethodResult.testName);
    }

    public int hashCode() {
        return Objects.hash(this.testName);
    }

    void test(TckTests suite) {
        System.out.printf("Starting test %s%n", this.testName);
        suite.before();
        try {
            this.ran = true;
            this.result = this.testMethod.apply(suite);
            this.passed = true;
            this.failureReason = null;
        }
        catch (Throwable t) {
            this.result = t.getMessage();
            this.passed = false;
            this.failureReason = this.verbose ? t : null;
        }
        finally {
            suite.after();
        }
    }
}

