/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.lra.client.LRAClient;
import org.eclipse.microprofile.lra.tck.TckResult;
import org.eclipse.microprofile.lra.tck.TckTests;

@Path(value="/tck")
public class TckResource {
    private static final String VERBOSE = "verbose";
    @Inject
    private LRAClient lraClient;
    private TckTests test;

    @PostConstruct
    private void setup() {
        TckTests.beforeClass(this.lraClient);
        this.test = new TckTests();
    }

    @PreDestroy
    private void tearDown() {
        TckTests.afterClass();
    }

    @PUT
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public TckResult runTck(@PathParam(value="name") String testName, @DefaultValue(value="true") @QueryParam(value="verbose") boolean isVerbose) {
        this.test.before();
        TckResult results = this.test.runTck(this.lraClient, testName, isVerbose);
        this.test.after();
        return results;
    }
}

