/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.lra.tck.TckMethodResult;
import org.eclipse.microprofile.lra.tck.TckTests;

class TckResult {
    private List<TckMethodResult> tests = new ArrayList<TckMethodResult>();
    private List<TckMethodResult> results;
    private List<String> failures = new ArrayList<String>();

    TckResult() {
    }

    void add(String testName, Function<TckTests, String> testMethod, boolean verbose) {
        this.tests.add(new TckMethodResult(testName, testMethod, verbose));
    }

    void runTests(TckTests testSpec, String testname) {
        Optional<TckMethodResult> tckTest = this.tests.stream().filter(name -> name.getTestName().equalsIgnoreCase(testname)).findFirst();
        if (tckTest.isPresent()) {
            tckTest.get().test(testSpec);
        } else {
            this.tests.forEach(t -> t.test(testSpec));
        }
        this.failures = this.tests.stream().filter(t -> !t.isPassed() && t.isRan()).map(TckMethodResult::getTestName).collect(Collectors.toList());
        this.results = this.tests.stream().filter(TckMethodResult::isRan).collect(Collectors.toList());
    }

    public int getNumberOfFailures() {
        return this.failures.size();
    }

    public List<String> getFailures() {
        return this.failures;
    }

    public List<TckMethodResult> getTestResults() {
        return this.results;
    }
}

