/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.client.GenericLRAException;
import org.eclipse.microprofile.lra.client.LRAClient;
import org.eclipse.microprofile.lra.client.LRAInfo;
import org.eclipse.microprofile.lra.tck.TckResult;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TckTests {
    private static final Long LRA_TIMEOUT_MILLIS = 50000L;
    private static URL micrserviceBaseUrl;
    private static URL rcBaseUrl;
    private static final int COORDINATOR_SWARM_PORT = 8082;
    private static final int TEST_SWARM_PORT = 8080;
    private static LRAClient lraClient;
    private static Client msClient;
    private static Client rcClient;
    private WebTarget msTarget;
    private WebTarget recoveryTarget;
    private static List<LRAInfo> oldLRAs;

    @BeforeClass
    public static void beforeClass(LRAClient lraClient) {
        TckTests.initTck(lraClient);
    }

    public TckResult runTck(LRAClient lraClient, String testname, boolean verbose) {
        TckResult run = new TckResult();
        TckTests.initTck(lraClient);
        run.add("timeLimit", TckTests::timeLimit, verbose);
        run.add("startLRA", TckTests::startLRA, verbose);
        run.add("cancelLRA", TckTests::cancelLRA, verbose);
        run.add("closeLRA", TckTests::closeLRA, verbose);
        run.add("getActiveLRAs", TckTests::getActiveLRAs, verbose);
        run.add("getAllLRAs", TckTests::getAllLRAs, verbose);
        run.add("isActiveLRA", TckTests::isActiveLRA, verbose);
        run.add("nestedActivity", TckTests::nestedActivity, verbose);
        run.add("completeMultiLevelNestedActivity", TckTests::completeMultiLevelNestedActivity, verbose);
        run.add("compensateMultiLevelNestedActivity", TckTests::compensateMultiLevelNestedActivity, verbose);
        run.add("mixedMultiLevelNestedActivity", TckTests::mixedMultiLevelNestedActivity, verbose);
        run.add("joinLRAViaHeader", TckTests::joinLRAViaHeader, verbose);
        run.add("join", TckTests::join, verbose);
        run.add("leaveLRA", TckTests::leaveLRA, verbose);
        run.add("leaveLRAViaAPI", TckTests::leaveLRAViaAPI, verbose);
        run.add("dependentLRA", TckTests::dependentLRA, verbose);
        run.add("cancelOn", TckTests::cancelOn, verbose);
        run.add("cancelOnFamily", TckTests::cancelOnFamily, verbose);
        run.add("acceptTest", TckTests::acceptTest, verbose);
        run.runTests(this, testname);
        return run;
    }

    private static void initTck(LRAClient lraClient) {
        TckTests.lraClient = lraClient;
        try {
            if (Boolean.valueOf(System.getProperty("enablePause", "true")).booleanValue()) {
                System.out.println("Getting ready to connect - expecting swarm lra coordinator is already up...");
                Thread.sleep(1000L);
            }
            int servicePort = Integer.getInteger("service.http.port", 8080);
            String rcHost = System.getProperty("lra.http.host", "localhost");
            int rcPort = Integer.getInteger("lra.http.port", 8082);
            String coordinatorPath = System.getProperty("lra.coordinator.path", "lra-coordinator");
            micrserviceBaseUrl = new URL(String.format("http://localhost:%d", servicePort));
            rcBaseUrl = new URL(String.format("http://%s:%d", rcHost, rcPort));
            lraClient.setCoordinatorURI(new URI(String.format("http://%s:%d/%s", rcHost, rcPort, coordinatorPath)));
            msClient = ClientBuilder.newClient();
            rcClient = ClientBuilder.newClient();
            oldLRAs = new ArrayList<LRAInfo>();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void afterClass() {
        oldLRAs.clear();
        lraClient.close();
        msClient.close();
        rcClient.close();
    }

    @Before
    public void before() {
        try {
            this.msTarget = msClient.target(URI.create(new URL(micrserviceBaseUrl, "/").toExternalForm()));
            this.recoveryTarget = rcClient.target(URI.create(new URL(rcBaseUrl, "/").toExternalForm()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void after() {
        List activeLRAs = lraClient.getActiveLRAs();
        if (activeLRAs.size() != 0) {
            activeLRAs.forEach(lra -> {
                try {
                    if (!oldLRAs.contains(lra)) {
                        System.out.printf("%s: WARNING: test did not close %s%n", "testName.getMethodName()", lra.getLraId());
                        oldLRAs.add((LRAInfo)lra);
                        lraClient.closeLRA(new URL(lra.getLraId()));
                    }
                }
                catch (MalformedURLException | WebApplicationException e) {
                    System.out.printf("After Test: exception %s closing %s%n", e.getMessage(), lra.getLraId());
                }
            });
        }
    }

    @Test
    private String startLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#startLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        lraClient.closeLRA(lra);
        return lra.toExternalForm();
    }

    @Test
    private String cancelLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#cancelLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        lraClient.cancelLRA(lra);
        List lras = lraClient.getAllLRAs();
        TckTests.assertNull(TckTests.getLra(lras, lra.toExternalForm()), "cancelLRA via client: lra still active", null);
        return lra.toExternalForm();
    }

    @Test
    private String closeLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#closelLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        lraClient.closeLRA(lra);
        List lras = lraClient.getAllLRAs();
        TckTests.assertNull(TckTests.getLra(lras, lra.toExternalForm()), "closeLRA via client: lra still active", null);
        return lra.toExternalForm();
    }

    @Test
    private String getActiveLRAs() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#getActiveLRAs", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        List lras = lraClient.getActiveLRAs();
        TckTests.assertNotNull(TckTests.getLra(lras, lra.toExternalForm()), "getActiveLRAs: getLra returned null", null);
        lraClient.closeLRA(lra);
        return lra.toExternalForm();
    }

    @Test
    private String getAllLRAs() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#getAllLRAs", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        List lras = lraClient.getAllLRAs();
        TckTests.assertNotNull(TckTests.getLra(lras, lra.toExternalForm()), "getAllLRAs: getLra returned null", null);
        lraClient.closeLRA(lra);
        return "passed";
    }

    private void getRecoveringLRAs() throws WebApplicationException {
    }

    @Test
    private String isActiveLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#isActiveLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        TckTests.assertTrue(lraClient.isActiveLRA(lra), null, null, lra);
        lraClient.closeLRA(lra);
        return lra.toExternalForm();
    }

    @Test
    private String isCompensatedLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#isCompensatedLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        lraClient.cancelLRA(lra);
        TckTests.assertTrue(lraClient.isCompensatedLRA(lra), null, null, lra);
        return lra.toExternalForm();
    }

    @Test
    private String isCompletedLRA() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#isCompletedLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        lraClient.closeLRA(lra);
        TckTests.assertTrue(lraClient.isCompletedLRA(lra), null, null, lra);
        return lra.toExternalForm();
    }

    @Test
    private String joinLRAViaBody() throws WebApplicationException {
        WebTarget resourcePath = this.msTarget.path("activities").path("work");
        Response response = resourcePath.request().put(Entity.text((Object)""));
        String lra = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        List lras = lraClient.getActiveLRAs();
        TckTests.assertNull(TckTests.getLra(lras, lra), "joinLRAViaBody: lra is still active", resourcePath);
        return "passed";
    }

    @Test
    private String nestedActivity() throws WebApplicationException {
        URL lra = lraClient.startLRA(null, "SpecTest#nestedActivity", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path("nestedActivity");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        Object parentId = response.getHeaders().getFirst((Object)"Long-Running-Action");
        TckTests.assertNotNull(parentId, "nestedActivity: null parent LRA", resourcePath);
        TckTests.assertEquals(lra.toExternalForm(), parentId, "nestedActivity should have returned the parent LRA", resourcePath);
        String nestedLraId = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        List lras = lraClient.getActiveLRAs();
        lraClient.closeLRA(lra);
        lras = lraClient.getActiveLRAs();
        TckTests.assertNull(TckTests.getLra(lras, nestedLraId), "nestedActivity: nested LRA should not be active", resourcePath);
        return lra.toExternalForm();
    }

    @Test
    private String completeMultiLevelNestedActivity() throws WebApplicationException {
        return this.multiLevelNestedActivity(CompletionType.complete, 1);
    }

    @Test
    private String compensateMultiLevelNestedActivity() throws WebApplicationException {
        return this.multiLevelNestedActivity(CompletionType.compensate, 1);
    }

    @Test
    private String mixedMultiLevelNestedActivity() throws WebApplicationException {
        return this.multiLevelNestedActivity(CompletionType.mixed, 2);
    }

    @Test
    private String joinLRAViaHeader() throws WebApplicationException {
        int cnt1 = this.completedCount(true);
        URL lra = lraClient.startLRA(null, "SpecTest#joinLRAViaBody", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        List lras = lraClient.getActiveLRAs();
        TckTests.assertNotNull(TckTests.getLra(lras, lra.toExternalForm()), "joinLRAViaHeader: missing lra", resourcePath);
        lraClient.closeLRA(lra);
        lras = lraClient.getActiveLRAs();
        TckTests.assertNull(TckTests.getLra(lras, lra.toExternalForm()), "joinLRAViaHeader: LRA should not be active", resourcePath);
        int cnt2 = this.completedCount(true);
        TckTests.assertEquals(cnt1 + 1, cnt2, "joinLRAViaHeader: wrong completion count", resourcePath);
        return "passed";
    }

    @Test
    private String join() throws WebApplicationException {
        List lras = lraClient.getActiveLRAs();
        int count = lras.size();
        URL lra = lraClient.startLRA(null, "SpecTest#join", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        lraClient.closeLRA(lra);
        lras = lraClient.getActiveLRAs();
        System.out.printf("join ok %d versus %d lras%n", count, lras.size());
        TckTests.assertEquals(count, lras.size(), "join: wrong LRA count", resourcePath);
        return lra.toExternalForm();
    }

    @Test
    private String leaveLRA() throws WebApplicationException {
        int cnt1 = this.completedCount(true);
        URL lra = lraClient.startLRA(null, "SpecTest#leaveLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        resourcePath = this.msTarget.path("activities").path("work");
        response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        resourcePath = this.msTarget.path("activities").path("leave");
        response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        lraClient.closeLRA(lra);
        int cnt2 = this.completedCount(true);
        TckTests.assertEquals(cnt1, cnt2, "leaveLRA: wrong completion count", resourcePath);
        return lra.toExternalForm();
    }

    @Test
    private String leaveLRAViaAPI() throws WebApplicationException {
        int cnt1 = this.completedCount(true);
        URL lra = lraClient.startLRA(null, "SpecTest#leaveLRA", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        resourcePath = this.msTarget.path("activities").path("work");
        response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        try {
            resourcePath = this.msTarget.path("activities").path("leave");
            response = resourcePath.path(URLEncoder.encode(lra.toString(), "UTF-8")).request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Entity.text((Object)String.format("%s: %s", resourcePath.getUri().toString(), e.getMessage()))).build());
        }
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        lraClient.closeLRA(lra);
        int cnt2 = this.completedCount(true);
        TckTests.assertEquals(cnt1, cnt2, String.format("leaveLRAViaAPI: wrong count %d versus %d", cnt1, cnt2), resourcePath);
        return "passed";
    }

    @Test
    private String dependentLRA() throws WebApplicationException {
        WebTarget resourcePath = this.msTarget.path("activities").path("startViaApi");
        Response response = resourcePath.request().put(Entity.text((Object)""));
        Object lraHeader = response.getHeaders().getFirst((Object)"Long-Running-Action");
        String id = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        TckTests.assertNotNull(lraHeader, String.format("JAX-RS response to PUT request should have returned the header %s", "Long-Running-Action"), resourcePath);
        TckTests.assertNotNull(id, "JAX-RS response to PUT request should have returned content", resourcePath);
        TckTests.assertEquals(id, lraHeader.toString(), "dependentLRA: resource returned wrong LRA", resourcePath);
        try {
            lraClient.closeLRA(new URL(lraHeader.toString()));
        }
        catch (MalformedURLException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return "passed";
    }

    @Test
    private String cancelOn() {
        this.cancelCheck("cancelOn");
        return "passed";
    }

    @Test
    private String cancelOnFamily() {
        this.cancelCheck("cancelOnFamily");
        return "passed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    private String timeLimit() {
        int[] cnt1 = new int[]{this.completedCount(true), this.completedCount(false)};
        try (Response response = null;){
            WebTarget resourcePath = this.msTarget.path("activities").path("timeLimit");
            response = resourcePath.request().get();
            this.checkStatusAndClose(response, -1, true, resourcePath);
            int[] cnt2 = new int[]{this.completedCount(true), this.completedCount(false)};
            TckTests.assertEquals(cnt1[0], cnt2[0], "timeLimit: complete was called instead of compensate", resourcePath);
            TckTests.assertEquals(cnt1[1] + 1, cnt2[1], "timeLimit: compensate should have been called", resourcePath);
        }
        return "passed";
    }

    private void testUserData() {
        List lras = lraClient.getActiveLRAs();
        int count = lras.size();
        String testData = "test participant data";
        WebTarget resourcePath = this.msTarget.path("activities").path("testUserData");
        Response response = resourcePath.request().put(Entity.text((Object)testData));
        String activityId = (String)response.readEntity(String.class);
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        lras = lraClient.getActiveLRAs();
        TckTests.assertEquals(count, lras.size(), "testUserData: testUserData produced the wrong LRA count", resourcePath);
        response = this.msTarget.path("activities").path("getActivity").queryParam("activityId", new Object[]{activityId}).request().get();
        String activity = (String)response.readEntity(String.class);
        TckTests.assertTrue(activity.contains("userData='" + testData), null, null, null);
        TckTests.assertTrue(activity.contains("endData='" + testData), null, null, null);
    }

    @Test
    private String acceptTest() throws WebApplicationException {
        this.joinAndEnd(true, true, "activities", "acceptWork");
        return "passed";
    }

    @Test
    private void joinAndEnd(boolean waitForRecovery, boolean close, String path, String path2) throws WebApplicationException {
        int countBefore = lraClient.getActiveLRAs().size();
        URL lra = lraClient.startLRA(null, "SpecTest#join", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path(path).path(path2);
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), false, resourcePath);
        if (close) {
            lraClient.closeLRA(lra);
        } else {
            lraClient.cancelLRA(lra);
        }
        if (waitForRecovery) {
            String recoveryPath = System.getProperty("lra.coordinator.recovery.path", "lra-recovery-coordinator");
            resourcePath = this.recoveryTarget.path(recoveryPath).path("recovery");
            Response response2 = resourcePath.request().get();
            this.checkStatusAndClose(response2, Response.Status.OK.getStatusCode(), false, resourcePath);
        }
        int countAfter = lraClient.getActiveLRAs().size();
        TckTests.assertEquals(countBefore, countAfter, "joinAndEnd: wrong LRA count", resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewTimeLimit() {
        int[] cnt1 = new int[]{this.completedCount(true), this.completedCount(false)};
        try (Response response = null;){
            WebTarget resourcePath = this.msTarget.path("activities").path("renewTimeLimit");
            response = resourcePath.request().get();
            this.checkStatusAndClose(response, -1, true, resourcePath);
            int[] cnt2 = new int[]{this.completedCount(true), this.completedCount(false)};
            TckTests.assertEquals(cnt1[0] + 1, cnt2[0], resourcePath.getUri().toString() + ": compensate was called instead of complete", resourcePath);
            TckTests.assertEquals(cnt1[1], cnt2[1], resourcePath.getUri().toString() + ": compensate should not have been called", resourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkStatusAndClose(Response response, int expected, boolean readEntity, WebTarget webTarget) {
        try {
            if (expected != -1 && response.getStatus() != expected) {
                if (webTarget != null) {
                    throw new WebApplicationException(webTarget.getUri().toString(), response);
                }
                throw new WebApplicationException(response);
            }
            if (readEntity) {
                String string = (String)response.readEntity(String.class);
                return string;
            }
        }
        finally {
            response.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int completedCount(boolean completed) {
        String path = completed ? "completedactivitycount" : "compensatedactivitycount";
        try (Response response = null;){
            WebTarget resourcePath = this.msTarget.path("activities").path(path);
            response = resourcePath.request().get();
            TckTests.assertEquals(Response.Status.OK.getStatusCode(), response.getStatus(), resourcePath.getUri().toString() + ": wrong status", resourcePath);
            int n = Integer.parseInt((String)response.readEntity(String.class));
            return n;
        }
    }

    private String multiLevelNestedActivity(CompletionType how, int nestedCnt) throws WebApplicationException {
        WebTarget resourcePath = this.msTarget.path("activities").path("multiLevelNestedActivity");
        int[] cnt1 = new int[]{this.completedCount(true), this.completedCount(false)};
        if (how == CompletionType.mixed && nestedCnt <= 1) {
            how = CompletionType.complete;
        }
        URL lra = lraClient.startLRA(null, "SpecTest#multiLevelNestedActivity", LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        String lraId = lra.toString();
        Response response = resourcePath.queryParam("nestedCnt", new Object[]{nestedCnt}).request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        String lraStr = this.checkStatusAndClose(response, Response.Status.OK.getStatusCode(), true, resourcePath);
        assert (lraStr != null);
        String[] lraArray = lraStr.split(",");
        List lras = lraClient.getActiveLRAs();
        URL[] urls = new URL[lraArray.length];
        IntStream.range(0, urls.length).forEach(i -> {
            try {
                urls[i] = new URL(lraArray[i]);
            }
            catch (MalformedURLException e) {
                TckTests.fail(String.format("%s (multiLevelNestedActivity): returned an invalid URL: %s", resourcePath.getUri().toString(), e.getMessage()));
            }
        });
        TckTests.assertEquals(nestedCnt + 1, lraArray.length, "multiLevelNestedActivity: step 1", resourcePath);
        TckTests.assertEquals(lraId, lraArray[0], "multiLevelNestedActivity: step 2", resourcePath);
        IntStream.rangeClosed(1, nestedCnt).forEach(i -> TckTests.assertNotNull(TckTests.getLra(lras, lraArray[i]), "missing nested LRA", resourcePath));
        TckTests.assertNotNull(TckTests.getLra(lras, lraArray[0]), "lra should have been found", resourcePath);
        int[] cnt2 = new int[]{this.completedCount(true), this.completedCount(false)};
        TckTests.assertEquals(cnt1[0] + nestedCnt, cnt2[0], "multiLevelNestedActivity: step 3", resourcePath);
        TckTests.assertEquals(cnt1[1], cnt2[1], "multiLevelNestedActivity: step 4", resourcePath);
        if (how == CompletionType.compensate) {
            lraClient.cancelLRA(lra);
        } else if (how == CompletionType.complete) {
            lraClient.closeLRA(lra);
        } else {
            lraClient.cancelLRA(urls[1]);
            lraClient.closeLRA(lra);
        }
        List lras2 = lraClient.getActiveLRAs();
        IntStream.rangeClosed(0, nestedCnt).forEach(i -> TckTests.assertNull(TckTests.getLra(lras2, lraArray[i]), "multiLevelNestedActivity: top level or nested activity still active", resourcePath));
        int[] cnt3 = new int[]{this.completedCount(true), this.completedCount(false)};
        if (how == CompletionType.complete) {
            TckTests.assertEquals(cnt2[0] + nestedCnt, cnt3[0], "multiLevelNestedActivity: step 5", resourcePath);
            TckTests.assertEquals(cnt1[1], cnt3[1], "multiLevelNestedActivity: step 6", resourcePath);
        } else if (how == CompletionType.compensate) {
            TckTests.assertEquals(cnt1[0] + nestedCnt, cnt3[0], "multiLevelNestedActivity: step 7", resourcePath);
            TckTests.assertEquals(cnt2[1] + 1 + nestedCnt, cnt3[1], "multiLevelNestedActivity: step 8", resourcePath);
        } else {
            TckTests.assertEquals(1, cnt3[1] - cnt1[1], "multiLevelNestedActivity: step 9", resourcePath);
            TckTests.assertEquals(nestedCnt + 1, cnt3[0] - cnt1[0], "multiLevelNestedActivity: step 10", resourcePath);
        }
        return "passed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCheck(String path) {
        int[] cnt1 = new int[]{this.completedCount(true), this.completedCount(false)};
        URL lra = lraClient.startLRA(null, "SpecTest#" + path, LRA_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        WebTarget resourcePath = this.msTarget.path("activities").path(path);
        try (Response response = null;){
            response = resourcePath.request().header("Long-Running-Action", (Object)lra).get();
            this.checkStatusAndClose(response, Response.Status.BAD_REQUEST.getStatusCode(), true, resourcePath);
            int[] cnt2 = new int[]{this.completedCount(true), this.completedCount(false)};
            TckTests.assertEquals(cnt1[0], cnt2[0], "complete was called instead of compensate", resourcePath);
            TckTests.assertEquals(cnt1[1] + 1, cnt2[1], "compensate should have been called", resourcePath);
            try {
                TckTests.assertTrue(lraClient.isActiveLRA(lra) == false, "cancelCheck: LRA should have been cancelled", resourcePath, lra);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private static LRAInfo getLra(List<LRAInfo> lras, String lraId) {
        for (LRAInfo lraInfo : lras) {
            if (!lraInfo.getLraId().equals(lraId)) continue;
            return lraInfo;
        }
        return null;
    }

    private static void assertTrue(boolean condition, String reason, WebTarget target, URL lra) {
        if (!condition) {
            throw new GenericLRAException(lra, 0, target.getUri().toString() + ": " + reason, null);
        }
    }

    private static <T> void assertEquals(T expected, T actual, String reason, WebTarget target) {
        if (!expected.equals(actual)) {
            throw new GenericLRAException(null, 0, target.getUri().toString() + ": " + reason, null);
        }
    }

    private static void fail(String msg) {
        System.out.printf("%s%n", msg);
        assert (false);
    }

    private static <T> void assertNotNull(T value, String reason, WebTarget target) {
        if (value == null) {
            if (target == null) {
                throw new GenericLRAException(null, 0, reason, null);
            }
            throw new GenericLRAException(null, 0, target.getUri().toString() + reason, null);
        }
    }

    private static <T> void assertNull(T value, String reason, WebTarget target) {
        if (value != null) {
            if (target == null) {
                throw new GenericLRAException(null, 0, reason, null);
            }
            throw new GenericLRAException(null, 0, target.getUri().toString() + reason, null);
        }
    }

    private static enum CompletionType {
        complete,
        compensate,
        mixed;

    }
}

