/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.CompensatorStatus;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRA;
import org.eclipse.microprofile.lra.annotation.Leave;
import org.eclipse.microprofile.lra.annotation.NestedLRA;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.TimeLimit;
import org.eclipse.microprofile.lra.client.GenericLRAException;
import org.eclipse.microprofile.lra.client.IllegalLRAStateException;
import org.eclipse.microprofile.lra.client.InvalidLRAIdException;
import org.eclipse.microprofile.lra.client.LRAClient;
import org.eclipse.microprofile.lra.tck.participant.api.Util;
import org.eclipse.microprofile.lra.tck.participant.model.Activity;
import org.eclipse.microprofile.lra.tck.participant.service.ActivityService;

@ApplicationScoped
@Path(value="activities")
@LRA(value=LRA.Type.SUPPORTS)
public class ActivityController {
    public static final String ACTIVITIES_PATH = "activities";
    public static final String ACCEPT_WORK = "acceptWork";
    private static final Logger LOGGER = Logger.getLogger(ActivityController.class.getName());
    @Inject
    private LRAClient lraClient;
    private static final AtomicInteger COMPLETED_COUNT = new AtomicInteger(0);
    private static final AtomicInteger COMPENSATED_COUNT = new AtomicInteger(0);
    @Context
    private UriInfo context;
    @Inject
    private ActivityService activityService;

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @Status
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response status(@HeaderParam(value="Long-Running-Action") String lraId) throws NotFoundException {
        Activity activity = this.activityService.getActivity(lraId);
        if (activity.getStatus() == null) {
            throw new IllegalLRAStateException(lraId, "getStatus", "LRA is not active");
        }
        if (activity.getAndDecrementAcceptCount() <= 0) {
            if (activity.getStatus() == CompensatorStatus.Completing) {
                activity.setStatus(CompensatorStatus.Completed);
            } else if (activity.getStatus() == CompensatorStatus.Compensating) {
                activity.setStatus(CompensatorStatus.Compensated);
            }
        }
        return Response.ok((Object)activity.getStatus().name()).build();
    }

    @PUT
    @Path(value="/leave/{LraUrl}")
    @Produces(value={"application/json"})
    public Response leaveWorkViaAPI(@PathParam(value="LraUrl") String lraUrl) throws NotFoundException, MalformedURLException {
        if (lraUrl != null) {
            Map<String, String> terminateURIs = Util.getTerminationUris(this.getClass(), this.context.getBaseUri());
            this.lraClient.leaveLRA(new URL(lraUrl), terminateURIs.get("Link"));
            this.activityService.getActivity(lraUrl);
            this.activityService.remove(lraUrl);
            return Response.ok((Object)lraUrl).build();
        }
        return Response.ok((Object)"non transactional").build();
    }

    @PUT
    @Path(value="/leave")
    @Produces(value={"application/json"})
    @Leave
    public Response leaveWork(@HeaderParam(value="Long-Running-Action") String lraId) throws NotFoundException {
        if (lraId != null) {
            this.activityService.getActivity(lraId);
            this.activityService.remove(lraId);
            return Response.ok((Object)lraId).build();
        }
        return Response.ok((Object)"non transactional").build();
    }

    @PUT
    @Path(value="/complete")
    @Produces(value={"application/json"})
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") String lraId, String userData) throws NotFoundException {
        COMPLETED_COUNT.incrementAndGet();
        this.assertHeaderPresent(lraId);
        Activity activity = this.activityService.getActivity(lraId);
        activity.setEndData(userData);
        if (activity.getAndDecrementAcceptCount() > 0) {
            activity.setStatus(CompensatorStatus.Completing);
            activity.setStatusUrl(String.format("%s/%s/%s/status", this.context.getBaseUri(), ACTIVITIES_PATH, lraId));
            return Response.accepted().location(URI.create(activity.getStatusUrl())).build();
        }
        activity.setStatus(CompensatorStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), lraId));
        System.out.printf("ActivityController completing %s%n", lraId);
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="/compensate")
    @Produces(value={"application/json"})
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") String lraId, String userData) throws NotFoundException {
        this.assertHeaderPresent(lraId);
        COMPENSATED_COUNT.incrementAndGet();
        Activity activity = this.activityService.getActivity(lraId);
        activity.setEndData(userData);
        if (activity.getAndDecrementAcceptCount() > 0) {
            activity.setStatus(CompensatorStatus.Compensating);
            activity.setStatusUrl(String.format("%s/%s/%s/status", this.context.getBaseUri(), ACTIVITIES_PATH, lraId));
            return Response.accepted().location(URI.create(activity.getStatusUrl())).build();
        }
        activity.setStatus(CompensatorStatus.Compensated);
        activity.setStatusUrl(String.format("%s/%s/activity/compensated", this.context.getBaseUri(), lraId));
        System.out.printf("ActivityController compensating %s%n", lraId);
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @DELETE
    @Path(value="/forget")
    @Produces(value={"application/json"})
    @Forget
    public Response forgetWork(@HeaderParam(value="Long-Running-Action") String lraId) {
        COMPLETED_COUNT.incrementAndGet();
        this.assertHeaderPresent(lraId);
        Activity activity = this.activityService.getActivity(lraId);
        this.activityService.remove(activity.getId());
        activity.setStatus(CompensatorStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), lraId));
        System.out.printf("ActivityController forgetting %s%n", lraId);
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="acceptWork")
    @LRA(value=LRA.Type.REQUIRED)
    public Response acceptWork(@HeaderParam(value="Long-Running-Action-Recovery") String rcvId, @HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        Activity activity = this.addWork(lraId, rcvId);
        if (activity == null) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"Missing lra data").build();
        }
        activity.setAcceptedCount(1);
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/supports")
    @LRA(value=LRA.Type.SUPPORTS)
    public Response supportsLRACall(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        this.addWork(lraId, null);
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/startViaApi")
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response subActivity(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertNotHeaderPresent(lraId);
        URL lra = this.lraClient.startLRA(null, "subActivity", Long.valueOf(0L), TimeUnit.SECONDS);
        lraId = lra.toString();
        this.addWork(lraId, null);
        String id = this.restPutInvocation(lra, "supports", "");
        if (id == null || !lraId.equals(id)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Entity.text((Object)"Unequal LRA ids")).build();
        }
        return Response.ok((Object)id).build();
    }

    @PUT
    @Path(value="/work")
    @LRA(value=LRA.Type.REQUIRED)
    public Response activityWithLRA(@HeaderParam(value="Long-Running-Action-Recovery") String rcvId, @HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        Activity activity = this.addWork(lraId, rcvId);
        if (activity == null) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"Missing lra data").build();
        }
        return Response.ok((Object)lraId).build();
    }

    private String restPutInvocation(URL lraURL, String path, String bodyText) {
        String id = null;
        Response response = ClientBuilder.newClient().target(this.context.getBaseUri()).path(ACTIVITIES_PATH).path(path).request().header("Long-Running-Action", (Object)lraURL).put(Entity.text((Object)bodyText));
        if (response.hasEntity()) {
            id = (String)response.readEntity(String.class);
        }
        this.checkStatusAndClose(response, Response.Status.OK.getStatusCode());
        return id;
    }

    @PUT
    @Path(value="/nestedActivity")
    @LRA(value=LRA.Type.MANDATORY)
    @NestedLRA
    public Response nestedActivity(@HeaderParam(value="Long-Running-Action-Recovery") String rcvId, @HeaderParam(value="Long-Running-Action") String nestedLRAId) {
        this.assertHeaderPresent(nestedLRAId);
        Activity activity = this.addWork(nestedLRAId, rcvId);
        if (activity == null) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"Missing lra data").build();
        }
        return Response.ok((Object)nestedLRAId).build();
    }

    @PUT
    @Path(value="/multiLevelNestedActivity")
    @LRA(value=LRA.Type.MANDATORY)
    public Response multiLevelNestedActivity(@HeaderParam(value="Long-Running-Action-Recovery") String rcvId, @HeaderParam(value="Long-Running-Action") String nestedLRAId, @QueryParam(value="nestedCnt") @DefaultValue(value="1") Integer nestedCnt) {
        URL lraURL;
        this.assertHeaderPresent(nestedLRAId);
        Activity activity = this.addWork(nestedLRAId, rcvId);
        if (activity == null) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)"Missing lra data").build();
        }
        try {
            lraURL = new URL(URLDecoder.decode(nestedLRAId, "UTF-8"));
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new InvalidLRAIdException(nestedLRAId, e.getMessage(), (Throwable)e);
        }
        CharSequence[] lras = new String[nestedCnt + 1];
        lras[0] = nestedLRAId;
        IntStream.range(1, lras.length).forEach(arg_0 -> this.lambda$multiLevelNestedActivity$0((String[])lras, lraURL, arg_0));
        return Response.ok((Object)String.join((CharSequence)",", lras)).build();
    }

    private Activity addWork(String lraId, String rcvId) {
        System.out.printf("ActivityController: work id %s and rcvId %s %n", lraId, rcvId);
        try {
            return this.activityService.getActivity(lraId);
        }
        catch (NotFoundException e) {
            Activity activity = new Activity(lraId);
            activity.setRcvUrl(rcvId);
            activity.setStatus(null);
            this.activityService.add(activity);
            return activity;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response findAll() {
        List<Activity> results = this.activityService.findAll();
        return Response.ok((Object)results.size()).build();
    }

    @GET
    @Path(value="/completedactivitycount")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response getCompletedCount() {
        return Response.ok((Object)COMPLETED_COUNT.get()).build();
    }

    @GET
    @Path(value="/compensatedactivitycount")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response getCompensatedCount() {
        return Response.ok((Object)COMPENSATED_COUNT.get()).build();
    }

    @GET
    @Path(value="/cancelOn")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.REQUIRED, cancelOn={Response.Status.NOT_FOUND, Response.Status.BAD_REQUEST})
    public Response cancelOn(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        this.activityService.add(new Activity(lraId));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Entity.text((Object)"Simulate buisiness logic failure")).build();
    }

    @GET
    @Path(value="/cancelOnFamily")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.REQUIRED, cancelOnFamily={Response.Status.Family.CLIENT_ERROR})
    public Response cancelOnFamily(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        this.activityService.add(new Activity(lraId));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Entity.text((Object)"Simulate buisiness logic failure")).build();
    }

    @GET
    @Path(value="/timeLimit")
    @Produces(value={"application/json"})
    @TimeLimit(limit=100L, unit=TimeUnit.MILLISECONDS)
    @LRA(value=LRA.Type.REQUIRED)
    public Response timeLimit(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        this.activityService.add(new Activity(lraId));
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)Entity.text((Object)"Simulate buisiness logic timeoout")).build();
    }

    @GET
    @Path(value="/renewTimeLimit")
    @Produces(value={"application/json"})
    @TimeLimit(limit=100L, unit=TimeUnit.MILLISECONDS)
    @LRA(value=LRA.Type.REQUIRED)
    public Response extendTimeLimit(@HeaderParam(value="Long-Running-Action") String lraId) {
        this.assertHeaderPresent(lraId);
        this.activityService.add(new Activity(lraId));
        try {
            this.lraClient.renewTimeLimit(ActivityController.lraToURL(lraId, "Invalid LRA id"), 300L, TimeUnit.MILLISECONDS);
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)Entity.text((Object)"Simulate buisiness logic timeoout")).build();
    }

    @PUT
    @Path(value="/{TxId}/compensate")
    @Produces(value={"application/json"})
    public Response compensate(@PathParam(value="TxId") String txId) throws NotFoundException {
        Activity activity = this.activityService.getActivity(txId);
        activity.setStatus(CompensatorStatus.Compensated);
        activity.setStatusUrl(String.format("%s/%s/activity/compensated", this.context.getBaseUri(), txId));
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="/{TxId}/complete")
    @Produces(value={"application/json"})
    public Response complete(@PathParam(value="TxId") String txId) throws NotFoundException {
        Activity activity = this.activityService.getActivity(txId);
        activity.setStatus(CompensatorStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), txId));
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="/{TxId}/forget")
    public void forget(@PathParam(value="TxId") String txId) throws NotFoundException {
        Activity activity = this.activityService.getActivity(txId);
        this.activityService.remove(activity.getId());
    }

    @GET
    @Path(value="/{TxId}/completed")
    @Produces(value={"application/json"})
    public String completedStatus(@PathParam(value="TxId") String txId) {
        return CompensatorStatus.Completed.name();
    }

    @GET
    @Path(value="/{TxId}/compensated")
    @Produces(value={"application/json"})
    public String compensatedStatus(@PathParam(value="TxId") String txId) {
        return CompensatorStatus.Compensated.name();
    }

    private void checkStatusAndClose(Response response, int expected) {
        try {
            if (response.getStatus() != expected) {
                throw new WebApplicationException(response);
            }
        }
        finally {
            response.close();
        }
    }

    private static URL lraToURL(String lraId, String errorMessage) {
        try {
            return new URL(lraId);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Can't construct URL from LRA id " + lraId, e);
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), errorMessage + ": " + lraId, (Throwable)e);
        }
    }

    private void assertHeaderPresent(String lraId) {
        if (lraId == null) {
            throw new InvalidLRAIdException(null, String.format("%s: missing %s header", this.context.getPath(), "Long-Running-Action"), null);
        }
    }

    private void assertNotHeaderPresent(String lraId) {
        if (lraId != null) {
            throw new InvalidLRAIdException(null, String.format("%s: unexpected %s header", this.context.getPath(), "Long-Running-Action"), null);
        }
    }

    private /* synthetic */ void lambda$multiLevelNestedActivity$0(String[] lras, URL lraURL, int i) {
        lras[i] = this.restPutInvocation(lraURL, "nestedActivity", "");
    }
}

