/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.Leave;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.TimeLimit;
import org.eclipse.microprofile.lra.client.GenericLRAException;

public class Util {
    private static final String COMPLETE = "complete";
    private static final String COMPENSATE = "compensate";
    private static final String STATUS = "status";
    private static final String LEAVE = "leave";
    private static final String FORGET = "forget";
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    private Util() {
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, URI baseUri) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        Path resourcePathAnnotation = compensatorClass.getAnnotation(Path.class);
        String resourcePath = resourcePathAnnotation == null ? "" : resourcePathAnnotation.value().replaceAll("^/+", "");
        String uriPrefix = String.format("%s:%s%s", baseUri.getScheme(), baseUri.getSchemeSpecificPart(), resourcePath).replaceAll("/$", "");
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (Util.checkMethod(paths, COMPENSATE, pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    TimeLimit timeLimit = method.getAnnotation(TimeLimit.class);
                    if (Util.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (Util.checkMethod(paths, COMPLETE, pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0 && Util.isAsyncCompletion(method)) {
                    asyncTermination[0] = true;
                }
                Util.checkMethod(paths, STATUS, pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                Util.checkMethod(paths, FORGET, pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                Util.checkMethod(paths, LEAVE, pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey(STATUS) && !paths.containsKey(FORGET)) {
            LOGGER.log(Level.WARNING, "LRA participant class " + compensatorClass + " with asynchronous temination but no @Status or @Forget annotations");
            throw new GenericLRAException(null, Response.Status.BAD_REQUEST.getStatusCode(), "LRA participant class with asynchronous temination but no @Status or @Forget annotations", null);
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (paths.size() != 0) {
            paths.forEach((k, v) -> Util.makeLink(linkHeaderValue, null, k, v));
            paths.put("Link", linkHeaderValue.toString());
        }
        return paths;
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.getName().equals(an.annotationType().getName())) continue;
                    LOGGER.log(Level.WARNING, "JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkMethod(Map<String, String> paths, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        paths.put(rel, uriPrefix + pathAnnotation.value());
        return 1;
    }
}

