/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.tck.participant.model.Activity;

@ApplicationScoped
public class ActivityService {
    private Map<String, Activity> activities = new HashMap<String, Activity>();

    public Activity getActivity(String txId) throws NotFoundException {
        if (!this.activities.containsKey(txId)) {
            throw new NotFoundException(Response.status((int)404).entity((Object)("Invalid activity id: " + txId)).build());
        }
        return this.activities.get(txId);
    }

    public List<Activity> findAll() {
        return new ArrayList<Activity>(this.activities.values());
    }

    public void add(Activity activity) {
        this.activities.putIfAbsent(activity.getId(), activity);
    }

    public void remove(String id) {
        this.activities.remove(id);
    }
}

