/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.core;

import com.cedarsoftware.io.JsonIo;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonIoConverter {
    public static Map jsonToJavaWithListsAndInts(String jsonInput) {
        ReadOptionsBuilder readOptionsBuilder = new ReadOptionsBuilder().returnAsJsonObjects();
        JsonObject rawServicesMap = (JsonObject)JsonIo.toJava((String)jsonInput, (ReadOptions)readOptionsBuilder.build()).asClass(JsonObject.class);
        return JsonIoConverter.convertArraysAndLongs((Map)rawServicesMap);
    }

    private static Map convertArraysAndLongs(Map input) {
        LinkedHashMap resultMap = new LinkedHashMap();
        Iterator iterator = input.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry castedEntry = entry = iterator.next();
            Object entryValue = castedEntry.getValue();
            Object entryKey = castedEntry.getKey();
            if (entryValue instanceof Object[]) {
                Object[] objectArray = (Object[])entryValue;
                resultMap.put(entryKey, JsonIoConverter.convertArray(objectArray));
                continue;
            }
            if (entryValue instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)entryValue;
                resultMap.put(entryKey, JsonIoConverter.convertArraysAndLongs((Map)jsonObject));
                continue;
            }
            if (entryValue instanceof Long) {
                Long longValue = (Long)entryValue;
                resultMap.put(entryKey, JsonIoConverter.tryAndConvertToInt(longValue));
                continue;
            }
            resultMap.put(entryKey, entryValue);
        }
        return resultMap;
    }

    static Number tryAndConvertToInt(Long longValue) {
        if (longValue.toString().length() <= 9) {
            int potentialInteger = longValue.intValue();
            return potentialInteger;
        }
        return longValue;
    }

    private static List convertArray(Object[] array) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object element : array) {
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                resultList.add(JsonIoConverter.convertArraysAndLongs((Map)jsonObject));
                continue;
            }
            if (element instanceof Object[]) {
                Object[] objectArray = (Object[])element;
                resultList.add(JsonIoConverter.convertArray(objectArray));
                continue;
            }
            if (element instanceof Long) {
                Long longValue = (Long)element;
                resultList.add(JsonIoConverter.tryAndConvertToInt(longValue));
                continue;
            }
            resultList.add(element);
        }
        return resultList;
    }
}

