/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AlternativePriorities;
import io.quarkus.arc.processor.AnnotationLiteralGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ClientProxyGenerator;
import io.quarkus.arc.processor.ComponentsProviderGenerator;
import io.quarkus.arc.processor.ContextInstancesGenerator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.CustomAlterableContexts;
import io.quarkus.arc.processor.CustomAlterableContextsGenerator;
import io.quarkus.arc.processor.DecoratorGenerator;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.arc.processor.InterceptionProxyGenerator;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.InterceptorGenerator;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InvokerGenerator;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.ObserverGenerator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.ObserverTransformer;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeRegistrar;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.arc.processor.bcextensions.ExtensionsEntryPoint;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class BeanProcessor {
    static final String DEFAULT_NAME = "Default";
    static final Logger LOGGER = Logger.getLogger(BeanProcessor.class);
    private final String name;
    private final ResourceOutput output;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final ReflectionRegistration reflectionRegistration;
    private final List<BeanRegistrar> beanRegistrars;
    private final List<ContextRegistrar> contextRegistrars;
    private final List<ObserverRegistrar> observerRegistrars;
    private final List<BeanDeploymentValidator> beanDeploymentValidators;
    private final BuildContextImpl buildContext;
    private final Predicate<DotName> applicationClassPredicate;
    private final BeanDeployment beanDeployment;
    private final boolean generateSources;
    private final boolean allowMocking;
    private final boolean transformUnproxyableClasses;
    private final Predicate<BeanDeployment> optimizeContexts;
    private final List<Function<BeanInfo, Consumer<BytecodeCreator>>> suppressConditionGenerators;
    protected final Predicate<DotName> injectionPointAnnotationsPredicate;
    private final ExtensionsEntryPoint buildCompatibleExtensions;
    private final CustomAlterableContexts customAlterableContexts;

    public static Builder builder() {
        return new Builder();
    }

    private BeanProcessor(Builder builder) {
        this.buildCompatibleExtensions = builder.buildCompatibleExtensions;
        this.customAlterableContexts = new CustomAlterableContexts(builder.applicationClassPredicate);
        if (this.buildCompatibleExtensions != null) {
            this.buildCompatibleExtensions.registerMetaAnnotations(builder, this.customAlterableContexts);
            this.buildCompatibleExtensions.runEnhancement(builder.beanArchiveComputingIndex, builder);
        }
        this.reflectionRegistration = builder.reflectionRegistration;
        this.applicationClassPredicate = builder.applicationClassPredicate;
        this.name = builder.name;
        this.output = builder.output;
        this.annotationLiterals = new AnnotationLiteralProcessor(builder.beanArchiveComputingIndex != null ? builder.beanArchiveComputingIndex : builder.beanArchiveImmutableIndex, this.applicationClassPredicate);
        this.generateSources = builder.generateSources;
        this.allowMocking = builder.allowMocking;
        this.optimizeContexts = builder.optimizeContexts;
        this.transformUnproxyableClasses = builder.transformUnproxyableClasses;
        this.suppressConditionGenerators = builder.suppressConditionGenerators;
        this.buildContext = new BuildContextImpl();
        this.buildContext.putInternal(BuildExtension.Key.INDEX, builder.beanArchiveComputingIndex != null ? builder.beanArchiveComputingIndex : builder.beanArchiveImmutableIndex);
        this.beanRegistrars = BeanProcessor.initAndSort(builder.beanRegistrars, this.buildContext);
        this.observerRegistrars = BeanProcessor.initAndSort(builder.observerRegistrars, this.buildContext);
        this.contextRegistrars = BeanProcessor.initAndSort(builder.contextRegistrars, this.buildContext);
        this.beanDeploymentValidators = BeanProcessor.initAndSort(builder.beanDeploymentValidators, this.buildContext);
        this.beanDeployment = new BeanDeployment(this.name, this.buildContext, builder);
        this.buildContext.putInternal(BuildExtension.Key.DEPLOYMENT, this.beanDeployment);
        this.injectionPointAnnotationsPredicate = Predicate.not(arg_0 -> ((DotName)DotNames.DEPRECATED).equals(arg_0));
    }

    public ContextRegistrar.RegistrationContext registerCustomContexts() {
        return this.beanDeployment.registerCustomContexts(this.contextRegistrars);
    }

    public void registerScopes() {
        this.beanDeployment.registerScopes();
    }

    public BeanRegistrar.RegistrationContext registerBeans() {
        return this.beanDeployment.registerBeans(this.beanRegistrars);
    }

    public ObserverRegistrar.RegistrationContext registerSyntheticObservers() {
        return this.beanDeployment.registerSyntheticObservers(this.observerRegistrars);
    }

    public void initialize(Consumer<BytecodeTransformer> bytecodeTransformerConsumer, List<Predicate<BeanInfo>> additionalUnusedBeanExclusions) {
        this.beanDeployment.init(bytecodeTransformerConsumer, additionalUnusedBeanExclusions);
    }

    public BeanDeploymentValidator.ValidationContext validate(Consumer<BytecodeTransformer> bytecodeTransformerConsumer) {
        BeanDeploymentValidator.ValidationContext validationContext = this.beanDeployment.validate(this.beanDeploymentValidators, bytecodeTransformerConsumer);
        this.customAlterableContexts.validate(validationContext, this.transformUnproxyableClasses, bytecodeTransformerConsumer);
        if (this.buildCompatibleExtensions != null) {
            this.buildCompatibleExtensions.runValidation(this.beanDeployment.getBeanArchiveIndex(), validationContext.get(BuildExtension.Key.BEANS), validationContext.get(BuildExtension.Key.OBSERVERS));
            this.buildCompatibleExtensions.registerValidationErrors(validationContext);
        }
        return validationContext;
    }

    public void processValidationErrors(BeanDeploymentValidator.ValidationContext validationContext) {
        BeanDeployment.processErrors(validationContext.getDeploymentProblems());
    }

    public List<ResourceOutput.Resource> generateResources(ReflectionRegistration reflectionRegistration, Set<String> existingClasses, final Consumer<BytecodeTransformer> bytecodeTransformerConsumer, final boolean detectUnusedFalsePositives, final ExecutorService executor) throws IOException, InterruptedException, ExecutionException {
        this.beanDeployment.resourceGenerationStarted();
        final ReflectionRegistration refReg = reflectionRegistration != null ? reflectionRegistration : this.reflectionRegistration;
        PrivateMembersCollector privateMembers = new PrivateMembersCollector();
        boolean optimizeContextsValue = this.optimizeContexts != null ? this.optimizeContexts.test(this.beanDeployment) : false;
        final HashMap<BeanInfo, String> beanToGeneratedName = new HashMap<BeanInfo, String>();
        final HashMap<ObserverInfo, String> observerToGeneratedName = new HashMap<ObserverInfo, String>();
        final HashMap<DotName, String> scopeToGeneratedName = new HashMap<DotName, String>();
        final BeanGenerator beanGenerator = new BeanGenerator(this.annotationLiterals, this.applicationClassPredicate, privateMembers, this.generateSources, refReg, existingClasses, beanToGeneratedName, this.injectionPointAnnotationsPredicate, this.suppressConditionGenerators);
        Collection<BeanInfo> beans = this.beanDeployment.getBeans();
        for (BeanInfo bean : beans) {
            beanGenerator.precomputeGeneratedName(bean);
        }
        final CustomAlterableContextsGenerator alterableContextsGenerator = new CustomAlterableContextsGenerator(this.generateSources);
        List<CustomAlterableContexts.CustomAlterableContextInfo> alterableContexts = this.customAlterableContexts.getRegistered();
        Set<DotName> singleContextNormalScopes = this.findSingleContextNormalScopes();
        final ClientProxyGenerator clientProxyGenerator = new ClientProxyGenerator(this.applicationClassPredicate, this.generateSources, this.allowMocking, refReg, existingClasses, singleContextNormalScopes);
        final InterceptorGenerator interceptorGenerator = new InterceptorGenerator(this.annotationLiterals, this.applicationClassPredicate, privateMembers, this.generateSources, refReg, existingClasses, beanToGeneratedName, this.injectionPointAnnotationsPredicate);
        Collection<InterceptorInfo> interceptors = this.beanDeployment.getInterceptors();
        for (InterceptorInfo interceptor : interceptors) {
            interceptorGenerator.precomputeGeneratedName(interceptor);
        }
        final DecoratorGenerator decoratorGenerator = new DecoratorGenerator(this.annotationLiterals, this.applicationClassPredicate, privateMembers, this.generateSources, refReg, existingClasses, beanToGeneratedName, this.injectionPointAnnotationsPredicate);
        Collection<DecoratorInfo> decorators = this.beanDeployment.getDecorators();
        for (DecoratorInfo decorator : decorators) {
            decoratorGenerator.precomputeGeneratedName(decorator);
        }
        final SubclassGenerator subclassGenerator = new SubclassGenerator(this.annotationLiterals, this.applicationClassPredicate, this.generateSources, refReg, existingClasses, privateMembers);
        final ObserverGenerator observerGenerator = new ObserverGenerator(this.annotationLiterals, this.applicationClassPredicate, privateMembers, this.generateSources, refReg, existingClasses, observerToGeneratedName, this.injectionPointAnnotationsPredicate, this.allowMocking);
        Collection<ObserverInfo> observers = this.beanDeployment.getObservers();
        for (ObserverInfo observer : observers) {
            observerGenerator.precomputeGeneratedName(observer);
        }
        final ContextInstancesGenerator contextInstancesGenerator = new ContextInstancesGenerator(this.generateSources, refReg, this.beanDeployment, scopeToGeneratedName);
        if (optimizeContextsValue) {
            contextInstancesGenerator.precomputeGeneratedName(BuiltinScope.APPLICATION.getName());
            contextInstancesGenerator.precomputeGeneratedName(BuiltinScope.REQUEST.getName());
        }
        final InvokerGenerator invokerGenerator = new InvokerGenerator(this.generateSources, this.applicationClassPredicate, this.beanDeployment, this.annotationLiterals, reflectionRegistration, this.injectionPointAnnotationsPredicate);
        Collection<InvokerInfo> invokers = this.beanDeployment.getInvokers();
        final InterceptionProxyGenerator interceptionGenerator = new InterceptionProxyGenerator(this.generateSources, this.applicationClassPredicate, this.annotationLiterals, reflectionRegistration);
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        if (executor != null) {
            LOGGER.debug((Object)"Generating resources in parallel");
            Iterator<Object> primaryTasks = new ArrayList();
            final ConcurrentLinkedQueue secondaryTasks = new ConcurrentLinkedQueue();
            primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                @Override
                public Collection<ResourceOutput.Resource> call() throws Exception {
                    return new ComponentsProviderGenerator(BeanProcessor.this.annotationLiterals, BeanProcessor.this.generateSources, detectUnusedFalsePositives).generate(BeanProcessor.this.name, BeanProcessor.this.beanDeployment, beanToGeneratedName, observerToGeneratedName, scopeToGeneratedName);
                }
            }));
            for (final InterceptorInfo interceptorInfo : interceptors) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        return interceptorGenerator.generate(interceptorInfo);
                    }
                }));
            }
            for (final DecoratorInfo decoratorInfo : decorators) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        return decoratorGenerator.generate(decoratorInfo);
                    }
                }));
            }
            for (final BeanInfo beanInfo : beans) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        Collection<ResourceOutput.Resource> beanResources = beanGenerator.generate(beanInfo);
                        for (final ResourceOutput.Resource resource : beanResources) {
                            if (ResourceOutput.Resource.SpecialType.BEAN != resource.getSpecialType()) continue;
                            if (beanInfo.getScope().isNormal()) {
                                secondaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                                    @Override
                                    public Collection<ResourceOutput.Resource> call() throws Exception {
                                        Collection<ResourceOutput.Resource> proxyResources = clientProxyGenerator.generate(beanInfo, resource.getFullyQualifiedName(), bytecodeTransformerConsumer, BeanProcessor.this.transformUnproxyableClasses);
                                        if (beanInfo.isClassBean()) {
                                            for (ResourceOutput.Resource r : proxyResources) {
                                                if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.CLIENT_PROXY) continue;
                                                refReg.registerClientProxy(beanInfo.getBeanClass(), r.getFullyQualifiedName());
                                                break;
                                            }
                                        }
                                        return proxyResources;
                                    }
                                }));
                            }
                            if (beanInfo.isSubclassRequired()) {
                                secondaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                                    @Override
                                    public Collection<ResourceOutput.Resource> call() throws Exception {
                                        Collection<ResourceOutput.Resource> subclassResources = subclassGenerator.generate(beanInfo, resource.getFullyQualifiedName());
                                        for (ResourceOutput.Resource r : subclassResources) {
                                            if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.SUBCLASS) continue;
                                            refReg.registerSubclass(beanInfo.getBeanClass(), r.getFullyQualifiedName());
                                            break;
                                        }
                                        return subclassResources;
                                    }
                                }));
                            }
                            if (beanInfo.getInterceptionProxy() == null) continue;
                            secondaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                                @Override
                                public Collection<ResourceOutput.Resource> call() throws Exception {
                                    Collection<ResourceOutput.Resource> interceptionResources = interceptionGenerator.generate(beanInfo);
                                    for (ResourceOutput.Resource r : interceptionResources) {
                                        if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.SUBCLASS) continue;
                                        refReg.registerSubclass(beanInfo.getInterceptionProxy().getTargetClass(), r.getFullyQualifiedName());
                                        break;
                                    }
                                    return interceptionResources;
                                }
                            }));
                        }
                        return beanResources;
                    }
                }));
            }
            for (final ObserverInfo observerInfo : observers) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        return observerGenerator.generate(observerInfo);
                    }
                }));
            }
            for (final InvokerInfo invokerInfo : invokers) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        return invokerGenerator.generate(invokerInfo);
                    }
                }));
            }
            for (final CustomAlterableContexts.CustomAlterableContextInfo customAlterableContextInfo : alterableContexts) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        return alterableContextsGenerator.generate(customAlterableContextInfo);
                    }
                }));
            }
            if (optimizeContextsValue) {
                primaryTasks.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

                    @Override
                    public Collection<ResourceOutput.Resource> call() throws Exception {
                        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
                        resources.addAll(contextInstancesGenerator.generate(BuiltinScope.APPLICATION.getName()));
                        resources.addAll(contextInstancesGenerator.generate(BuiltinScope.REQUEST.getName()));
                        return resources;
                    }
                }));
            }
            Iterator<Object> iterator = primaryTasks.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                resources.addAll((Collection)future.get());
            }
            for (Future future : secondaryTasks) {
                resources.addAll((Collection)future.get());
            }
        } else {
            LOGGER.debug((Object)"Generating resources in series");
            for (InterceptorInfo interceptor : interceptors) {
                resources.addAll(interceptorGenerator.generate(interceptor));
            }
            for (DecoratorInfo decorator : decorators) {
                resources.addAll(decoratorGenerator.generate(decorator));
            }
            for (BeanInfo bean : beans) {
                for (ResourceOutput.Resource resource : beanGenerator.generate(bean)) {
                    resources.add(resource);
                    if (!ResourceOutput.Resource.SpecialType.BEAN.equals((Object)resource.getSpecialType())) continue;
                    if (bean.getScope().isNormal()) {
                        Collection<ResourceOutput.Resource> proxyResources = clientProxyGenerator.generate(bean, resource.getFullyQualifiedName(), bytecodeTransformerConsumer, this.transformUnproxyableClasses);
                        if (bean.isClassBean()) {
                            for (ResourceOutput.Resource r : proxyResources) {
                                if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.CLIENT_PROXY) continue;
                                refReg.registerClientProxy(bean.getBeanClass(), r.getFullyQualifiedName());
                                break;
                            }
                        }
                        resources.addAll(proxyResources);
                    }
                    if (bean.isSubclassRequired()) {
                        Collection<ResourceOutput.Resource> subclassResources = subclassGenerator.generate(bean, resource.getFullyQualifiedName());
                        for (ResourceOutput.Resource r : subclassResources) {
                            if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.SUBCLASS) continue;
                            refReg.registerSubclass(bean.getBeanClass(), r.getFullyQualifiedName());
                            break;
                        }
                        resources.addAll(subclassResources);
                    }
                    if (bean.getInterceptionProxy() == null) continue;
                    Collection<ResourceOutput.Resource> interceptionResources = interceptionGenerator.generate(bean);
                    for (ResourceOutput.Resource r : interceptionResources) {
                        if (r.getSpecialType() != ResourceOutput.Resource.SpecialType.SUBCLASS) continue;
                        refReg.registerSubclass(bean.getInterceptionProxy().getTargetClass(), r.getFullyQualifiedName());
                        break;
                    }
                    resources.addAll(interceptionResources);
                }
            }
            for (ObserverInfo observer : observers) {
                resources.addAll(observerGenerator.generate(observer));
            }
            for (InvokerInfo invoker : invokers) {
                resources.addAll(invokerGenerator.generate(invoker));
            }
            for (CustomAlterableContexts.CustomAlterableContextInfo info : alterableContexts) {
                resources.addAll(alterableContextsGenerator.generate(info));
            }
            resources.addAll(new ComponentsProviderGenerator(this.annotationLiterals, this.generateSources, detectUnusedFalsePositives).generate(this.name, this.beanDeployment, beanToGeneratedName, observerToGeneratedName, scopeToGeneratedName));
            if (optimizeContextsValue) {
                resources.addAll(contextInstancesGenerator.generate(BuiltinScope.APPLICATION.getName()));
                resources.addAll(contextInstancesGenerator.generate(BuiltinScope.REQUEST.getName()));
            }
        }
        if (this.annotationLiterals.hasLiteralsToGenerate()) {
            AnnotationLiteralGenerator generator = new AnnotationLiteralGenerator(this.generateSources);
            if (executor != null) {
                Collection<Future<Collection<ResourceOutput.Resource>>> annotationTasks = generator.generate(this.annotationLiterals.getCache(), existingClasses, executor);
                for (Future future : annotationTasks) {
                    resources.addAll((Collection)future.get());
                }
            } else {
                resources.addAll(generator.generate(this.annotationLiterals.getCache(), existingClasses));
            }
        }
        privateMembers.log();
        if (this.output != null) {
            for (ResourceOutput.Resource resource : resources) {
                this.output.writeResource(resource);
            }
        }
        return resources;
    }

    public BeanDeployment getBeanDeployment() {
        return this.beanDeployment;
    }

    public AnnotationLiteralProcessor getAnnotationLiteralProcessor() {
        return this.annotationLiterals;
    }

    public BeanDeployment process() throws IOException, InterruptedException, ExecutionException {
        Consumer<BytecodeTransformer> unsupportedBytecodeTransformer = new Consumer<BytecodeTransformer>(){

            @Override
            public void accept(BytecodeTransformer transformer) {
                throw new UnsupportedOperationException();
            }
        };
        this.registerCustomContexts();
        this.registerScopes();
        this.registerBeans();
        this.beanDeployment.initBeanByTypeMap();
        this.registerSyntheticObservers();
        this.initialize(unsupportedBytecodeTransformer, Collections.emptyList());
        BeanDeploymentValidator.ValidationContext validationContext = this.validate(unsupportedBytecodeTransformer);
        this.processValidationErrors(validationContext);
        this.generateResources(ReflectionRegistration.NOOP, new HashSet<String>(), unsupportedBytecodeTransformer, this.beanDeployment.removeUnusedBeans, null);
        return this.beanDeployment;
    }

    public Predicate<DotName> getInjectionPointAnnotationsPredicate() {
        return this.injectionPointAnnotationsPredicate;
    }

    private Set<DotName> findSingleContextNormalScopes() {
        HashMap<DotName, Integer> contextsForScope = new HashMap<DotName, Integer>();
        contextsForScope.put(BuiltinScope.REQUEST.getName(), 1);
        for (Map.Entry<ScopeInfo, List<Function<MethodCreator, ResultHandle>>> entry2 : this.beanDeployment.getCustomContexts().entrySet()) {
            if (!entry2.getKey().isNormal()) continue;
            contextsForScope.merge(entry2.getKey().getDotName(), entry2.getValue().size(), Integer::sum);
        }
        return contextsForScope.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    static <E extends BuildExtension> List<E> initAndSort(List<E> extensions, BuildExtension.BuildContext buildContext) {
        Iterator<E> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            if (((BuildExtension)iterator.next()).initialize(buildContext)) continue;
            iterator.remove();
        }
        extensions.sort(BuildExtension::compare);
        return extensions;
    }

    public static class Builder {
        String name = "Default";
        IndexView beanArchiveComputingIndex;
        IndexView beanArchiveImmutableIndex;
        IndexView applicationIndex;
        Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations = Collections.emptySet();
        ResourceOutput output;
        ReflectionRegistration reflectionRegistration = ReflectionRegistration.NOOP;
        final List<DotName> resourceAnnotations = new ArrayList<DotName>();
        final List<AnnotationTransformation> annotationTransformers = new ArrayList<AnnotationTransformation>();
        final List<InjectionPointsTransformer> injectionPointTransformers = new ArrayList<InjectionPointsTransformer>();
        final List<ObserverTransformer> observerTransformers = new ArrayList<ObserverTransformer>();
        final List<BeanRegistrar> beanRegistrars = new ArrayList<BeanRegistrar>();
        final List<ObserverRegistrar> observerRegistrars = new ArrayList<ObserverRegistrar>();
        final List<ContextRegistrar> contextRegistrars = new ArrayList<ContextRegistrar>();
        final List<QualifierRegistrar> qualifierRegistrars = new ArrayList<QualifierRegistrar>();
        final List<InterceptorBindingRegistrar> interceptorBindingRegistrars = new ArrayList<InterceptorBindingRegistrar>();
        final List<StereotypeRegistrar> stereotypeRegistrars = new ArrayList<StereotypeRegistrar>();
        final List<BeanDeploymentValidator> beanDeploymentValidators = new ArrayList<BeanDeploymentValidator>();
        final List<Function<BeanInfo, Consumer<BytecodeCreator>>> suppressConditionGenerators = new ArrayList<Function<BeanInfo, Consumer<BytecodeCreator>>>();
        boolean removeUnusedBeans = false;
        final List<Predicate<BeanInfo>> removalExclusions = new ArrayList<Predicate<BeanInfo>>();
        boolean generateSources = false;
        boolean jtaCapabilities = false;
        boolean transformUnproxyableClasses = false;
        boolean transformPrivateInjectedFields = false;
        boolean failOnInterceptedPrivateMethod = false;
        boolean allowMocking = false;
        boolean strictCompatibility = false;
        Predicate<BeanDeployment> optimizeContexts;
        AlternativePriorities alternativePriorities;
        final List<Predicate<ClassInfo>> excludeTypes = new ArrayList<Predicate<ClassInfo>>();
        ExtensionsEntryPoint buildCompatibleExtensions;
        Predicate<DotName> applicationClassPredicate = dn -> true;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setComputingBeanArchiveIndex(IndexView index) {
            this.beanArchiveComputingIndex = index;
            return this;
        }

        public Builder setImmutableBeanArchiveIndex(IndexView index) {
            this.beanArchiveImmutableIndex = index;
            return this;
        }

        public Builder setApplicationIndex(IndexView index) {
            this.applicationIndex = index;
            return this;
        }

        public Builder setAdditionalBeanDefiningAnnotations(Collection<BeanDefiningAnnotation> additionalBeanDefiningAnnotations) {
            Objects.requireNonNull(additionalBeanDefiningAnnotations);
            this.additionalBeanDefiningAnnotations = additionalBeanDefiningAnnotations;
            return this;
        }

        public Builder addQualifierRegistrar(QualifierRegistrar qualifierRegistrar) {
            this.qualifierRegistrars.add(qualifierRegistrar);
            return this;
        }

        public Builder addInterceptorBindingRegistrar(InterceptorBindingRegistrar bindingRegistrar) {
            this.interceptorBindingRegistrars.add(bindingRegistrar);
            return this;
        }

        public Builder addStereotypeRegistrar(StereotypeRegistrar stereotypeRegistrar) {
            this.stereotypeRegistrars.add(stereotypeRegistrar);
            return this;
        }

        public Builder setOutput(ResourceOutput output) {
            this.output = output;
            return this;
        }

        public Builder setReflectionRegistration(ReflectionRegistration reflectionRegistration) {
            this.reflectionRegistration = reflectionRegistration;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addAnnotationTransformer(AnnotationsTransformer transformer) {
            this.annotationTransformers.add(transformer);
            return this;
        }

        public Builder addAnnotationTransformation(AnnotationTransformation transformation) {
            this.annotationTransformers.add(transformation);
            return this;
        }

        public Builder addInjectionPointTransformer(InjectionPointsTransformer transformer) {
            this.injectionPointTransformers.add(transformer);
            return this;
        }

        public Builder addObserverTransformer(ObserverTransformer transformer) {
            this.observerTransformers.add(transformer);
            return this;
        }

        public Builder addResourceAnnotations(Collection<DotName> resourceAnnotations) {
            this.resourceAnnotations.addAll(resourceAnnotations);
            return this;
        }

        public Builder addBeanRegistrar(BeanRegistrar registrar) {
            this.beanRegistrars.add(registrar);
            return this;
        }

        public Builder addObserverRegistrar(ObserverRegistrar registrar) {
            this.observerRegistrars.add(registrar);
            return this;
        }

        public Builder addContextRegistrar(ContextRegistrar registrar) {
            this.contextRegistrars.add(registrar);
            return this;
        }

        public Builder addBeanDeploymentValidator(BeanDeploymentValidator validator) {
            this.beanDeploymentValidators.add(validator);
            return this;
        }

        public Builder setApplicationClassPredicate(Predicate<DotName> applicationClassPredicate) {
            this.applicationClassPredicate = applicationClassPredicate;
            return this;
        }

        public Builder setJtaCapabilities(boolean jtaCapabilities) {
            this.jtaCapabilities = jtaCapabilities;
            return this;
        }

        public void setAllowMocking(boolean allowMocking) {
            this.allowMocking = allowMocking;
        }

        public Builder setRemoveUnusedBeans(boolean removeUnusedBeans) {
            this.removeUnusedBeans = removeUnusedBeans;
            return this;
        }

        public Builder addRemovalExclusion(Predicate<BeanInfo> predicate) {
            this.removalExclusions.add(predicate);
            return this;
        }

        public Builder setTransformUnproxyableClasses(boolean value) {
            this.transformUnproxyableClasses = value;
            return this;
        }

        public Builder setTransformPrivateInjectedFields(boolean value) {
            this.transformPrivateInjectedFields = value;
            return this;
        }

        public void setFailOnInterceptedPrivateMethod(boolean failOnInterceptedPrivateMethod) {
            this.failOnInterceptedPrivateMethod = failOnInterceptedPrivateMethod;
        }

        public Builder setGenerateSources(boolean value) {
            this.generateSources = value;
            return this;
        }

        public Builder setStrictCompatibility(boolean strictCompatibility) {
            this.strictCompatibility = strictCompatibility;
            return this;
        }

        public Builder setOptimizeContexts(final boolean value) {
            return this.setOptimizeContexts(new Predicate<BeanDeployment>(){

                @Override
                public boolean test(BeanDeployment t) {
                    return value;
                }
            });
        }

        public Builder setOptimizeContexts(Predicate<BeanDeployment> fun) {
            this.optimizeContexts = fun;
            return this;
        }

        public Builder setAlternativePriorities(AlternativePriorities priorities) {
            this.alternativePriorities = priorities;
            return this;
        }

        public Builder addExcludeType(Predicate<ClassInfo> predicate) {
            this.excludeTypes.add(predicate);
            return this;
        }

        public Builder addSuppressConditionGenerator(Function<BeanInfo, Consumer<BytecodeCreator>> generator) {
            this.suppressConditionGenerators.add(generator);
            return this;
        }

        public Builder setBuildCompatibleExtensions(ExtensionsEntryPoint buildCompatibleExtensions) {
            this.buildCompatibleExtensions = buildCompatibleExtensions;
            return this;
        }

        public BeanProcessor build() {
            return new BeanProcessor(this);
        }
    }

    static class BuildContextImpl
    implements BuildExtension.BuildContext {
        private final Map<String, Object> data = new ConcurrentHashMap<String, Object>();

        BuildContextImpl() {
        }

        @Override
        public <V> V get(BuildExtension.Key<V> key) {
            return (V)this.data.get(key.asString());
        }

        @Override
        public <V> V put(BuildExtension.Key<V> key, V value) {
            String keyStr = key.asString();
            if (keyStr.startsWith(BuildExtension.Key.BUILT_IN_PREFIX)) {
                throw new IllegalArgumentException("Key may not start wit " + BuildExtension.Key.BUILT_IN_PREFIX + ": " + keyStr);
            }
            return this.putInternal(keyStr, value);
        }

        <V> V putInternal(BuildExtension.Key<V> key, V value) {
            return (V)this.data.put(key.asString(), value);
        }

        <V> V putInternal(String key, V value) {
            return (V)this.data.put(key, value);
        }
    }

    static class PrivateMembersCollector {
        private final List<String> appDescriptions = new CopyOnWriteArrayList<String>();
        private final List<String> fwkDescriptions = LOGGER.isDebugEnabled() ? new CopyOnWriteArrayList() : null;

        void add(boolean isApplicationClass, String description) {
            if (isApplicationClass) {
                this.appDescriptions.add(description);
            } else if (this.fwkDescriptions != null) {
                this.fwkDescriptions.add(description);
            }
        }

        private void log() {
            if (!this.appDescriptions.isEmpty()) {
                int limit = LOGGER.isDebugEnabled() ? Integer.MAX_VALUE : 3;
                Object info = this.appDescriptions.stream().limit(limit).map(d -> "\t- " + d).collect(Collectors.joining(",\n"));
                if (this.appDescriptions.size() > limit) {
                    info = (String)info + "\n\t- and " + (this.appDescriptions.size() - limit) + " more - please enable debug logging to see the full list";
                }
                LOGGER.infof("Found unrecommended usage of private members (use package-private instead) in application beans:%n%s", info);
            }
            if (this.fwkDescriptions != null && !this.fwkDescriptions.isEmpty()) {
                LOGGER.debugf("Found unrecommended usage of private members (use package-private instead) in framework beans:%n%s", (Object)this.fwkDescriptions.stream().map(d -> "\t- " + d).collect(Collectors.joining(",\n")));
            }
        }
    }
}

