/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class BindingsDiscovery {
    private final BeanDeployment beanDeployment;
    private final ClassInfo bindingsSourceClass;

    BindingsDiscovery(BeanDeployment beanDeployment, ClassInfo bindingsSourceClass) {
        this.beanDeployment = Objects.requireNonNull(beanDeployment);
        this.bindingsSourceClass = bindingsSourceClass;
    }

    boolean hasAnnotation(MethodInfo method, DotName annotation) {
        if (this.bindingsSourceClass == null) {
            return this.beanDeployment.hasAnnotation((AnnotationTarget)method, annotation);
        }
        MethodInfo corresponding = this.findCorrespondingMethod(method);
        return corresponding != null && this.beanDeployment.hasAnnotation((AnnotationTarget)corresponding, annotation);
    }

    Collection<AnnotationInstance> getAnnotations(MethodInfo method) {
        if (this.bindingsSourceClass == null) {
            return this.beanDeployment.getAnnotations((AnnotationTarget)method);
        }
        MethodInfo corresponding = this.findCorrespondingMethod(method);
        return corresponding != null ? this.beanDeployment.getAnnotations((AnnotationTarget)corresponding) : Set.of();
    }

    private MethodInfo findCorrespondingMethod(MethodInfo method) {
        for (MethodInfo candidate : this.bindingsSourceClass.methods()) {
            if (!method.name().equals(candidate.name()) || !method.returnType().equals((Object)candidate.returnType()) || !method.parameterTypes().equals(candidate.parameterTypes()) || Modifier.isStatic(method.flags()) != Modifier.isStatic(candidate.flags())) continue;
            return candidate;
        }
        return null;
    }
}

