/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.FieldInfoImpl;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

class InjectionPointInfoImpl
implements jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo {
    private final IndexView jandexIndex;
    private final AllAnnotationOverlays annotationOverlays;
    private final InjectionPointInfo arcInjectionPointInfo;

    InjectionPointInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, InjectionPointInfo arcInjectionPointInfo) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.arcInjectionPointInfo = arcInjectionPointInfo;
    }

    public Type type() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, this.arcInjectionPointInfo.getRequiredType());
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.arcInjectionPointInfo.getRequiredQualifiers().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public DeclarationInfo declaration() {
        if (this.arcInjectionPointInfo.isField()) {
            FieldInfo jandexField = this.arcInjectionPointInfo.getTarget().asField();
            return new FieldInfoImpl(this.jandexIndex, this.annotationOverlays, jandexField);
        }
        if (this.arcInjectionPointInfo.isParam()) {
            MethodInfo jandexMethod = this.arcInjectionPointInfo.getTarget().asMethod();
            int parameterPosition = this.arcInjectionPointInfo.getPosition();
            MethodParameterInfo jandexParameter = MethodParameterInfo.create((MethodInfo)jandexMethod, (short)((short)parameterPosition));
            return new ParameterInfoImpl(this.jandexIndex, this.annotationOverlays, jandexParameter);
        }
        throw new IllegalStateException("Unknown injection point: " + this.arcInjectionPointInfo);
    }
}

