/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ComputingCache;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.ContextInstanceHandleImpl;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

abstract class AbstractSharedContext
implements InjectableContext {
    private final ComputingCache<Key<?>, ContextInstanceHandle<?>> instances = new ComputingCache<Key, ContextInstanceHandle>(key -> AbstractSharedContext.createInstanceHandle((InjectableBean)((Key)key).contextual, ((Key)key).creationalContext));

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        return this.instances.getValue(new Key<T>(contextual, creationalContext)).get();
    }

    public <T> T get(Contextual<T> contextual) {
        ContextInstanceHandle<?> handle = this.instances.getValueIfPresent(new Key<T>(contextual, null));
        return handle != null ? (T)handle.get() : null;
    }

    @Override
    public Collection<ContextInstanceHandle<?>> getAll() {
        return new ArrayList(this.instances.getPresentValues());
    }

    public boolean isActive() {
        return true;
    }

    public void destroy(Contextual<?> contextual) {
        ContextInstanceHandle<?> handle = this.instances.remove(new Key(contextual, null));
        if (handle != null) {
            handle.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        Set<ContextInstanceHandle<?>> values = this.instances.getPresentValues();
        Iterator<ContextInstanceHandle<?>> iterator = values.iterator();
        while (iterator.hasNext()) {
            ContextInstanceHandle<?> instanceHandle = iterator.next();
            if (instanceHandle.getBean().getDeclaringBean() == null) continue;
            instanceHandle.destroy();
            iterator.remove();
        }
        for (ContextInstanceHandle<?> instanceHandle : values) {
            instanceHandle.destroy();
        }
        this.instances.clear();
    }

    private static ContextInstanceHandle createInstanceHandle(InjectableBean bean, CreationalContext ctx) {
        return new ContextInstanceHandleImpl<Object>(bean, bean.create(ctx), ctx);
    }

    private static class Key<T> {
        private Contextual<T> contextual;
        private CreationalContext<T> creationalContext;

        public Key(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            this.contextual = contextual;
            this.creationalContext = creationalContext;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contextual == null ? 0 : this.contextual.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.contextual == null ? other.contextual != null : !this.contextual.equals(other.contextual));
        }

        public String toString() {
            return "Key [contextual=" + this.contextual + "]";
        }
    }
}

