/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ArcContainerImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class Arc {
    private static final AtomicReference<ArcContainerImpl> INSTANCE = new AtomicReference();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    public static ArcContainer initialize() {
        if (INITIALIZED.compareAndSet(false, true)) {
            ArcContainerImpl container = new ArcContainerImpl();
            INSTANCE.set(container);
            container.init();
        }
        return Arc.container();
    }

    public static ArcContainer container() {
        return INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (INSTANCE.get() != null) {
            AtomicReference<ArcContainerImpl> atomicReference = INSTANCE;
            synchronized (atomicReference) {
                if (INSTANCE.get() != null) {
                    INSTANCE.get().shutdown();
                    INSTANCE.set(null);
                    INITIALIZED.set(false);
                }
            }
        }
    }
}

