/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ArcContainerImpl;
import io.quarkus.arc.AsyncEventDeliveryStage;
import io.quarkus.arc.EventObjectTypeResolverBuilder;
import io.quarkus.arc.HierarchyDiscovery;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.TypeResolver;
import io.quarkus.arc.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.NotificationOptions;
import javax.enterprise.event.ObserverException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.EventContext;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;

class EventImpl<T>
implements Event<T> {
    private static final int DEFAULT_CACHE_CAPACITY = 4;
    private static final Executor DEFAULT_EXECUTOR = ForkJoinPool.commonPool();
    private static final NotificationOptions DEFAULT_OPTIONS = NotificationOptions.ofExecutor((Executor)DEFAULT_EXECUTOR);
    private final HierarchyDiscovery injectionPointTypeHierarchy;
    private final Type eventType;
    private final Set<Annotation> qualifiers;
    private final ConcurrentMap<Class<?>, Notifier<? super T>> notifiers;
    private volatile transient Notifier<? super T> lastNotifier;

    public EventImpl(Type eventType, Set<Annotation> qualifiers) {
        if (eventType instanceof ParameterizedType) {
            eventType = ((ParameterizedType)eventType).getActualTypeArguments()[0];
        }
        this.eventType = eventType;
        this.injectionPointTypeHierarchy = new HierarchyDiscovery(eventType);
        this.qualifiers = qualifiers;
        this.qualifiers.add((Annotation)Any.Literal.INSTANCE);
        this.notifiers = new ConcurrentHashMap(4);
    }

    public void fire(T event) {
        this.getNotifier(event.getClass()).notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
    }

    public <U extends T> CompletionStage<U> fireAsync(U event) {
        return this.fireAsync(event, DEFAULT_OPTIONS);
    }

    public <U extends T> CompletionStage<U> fireAsync(U event, NotificationOptions options) {
        Objects.requireNonNull(options);
        Notifier<T> notifier = this.getNotifier(event.getClass());
        Executor executor = options.getExecutor();
        if (executor == null) {
            executor = DEFAULT_EXECUTOR;
        }
        if (notifier.isEmpty()) {
            return AsyncEventDeliveryStage.completed(event, executor);
        }
        Supplier<Object> notifyLogic = () -> {
            CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
            notifier.notify(event, exceptionHandler, true);
            this.handleExceptions(exceptionHandler);
            return event;
        };
        Supplier<Object> withinRequest = () -> {
            ArcContainer container = Arc.container();
            if (container.getActiveContext(RequestScoped.class) != null) {
                return notifyLogic.get();
            }
            ManagedContext requestContext = container.requestContext();
            try {
                requestContext.activate();
                Object t = notifyLogic.get();
                return t;
            }
            finally {
                requestContext.terminate();
            }
        };
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(withinRequest, executor);
        return new AsyncEventDeliveryStage<Object>(completableFuture, executor);
    }

    private Notifier<? super T> getNotifier(Class<?> runtimeType) {
        Notifier<? super T> notifier = this.lastNotifier;
        if (notifier != null && ((Notifier)notifier).runtimeType.equals(runtimeType)) {
            return notifier;
        }
        this.lastNotifier = this.notifiers.computeIfAbsent(runtimeType, this::createNotifier);
        return this.lastNotifier;
    }

    public Event<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(this.eventType, mergerdQualifiers);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype, mergerdQualifiers);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype.getType(), mergerdQualifiers);
    }

    private Notifier<? super T> createNotifier(Class<?> runtimeType) {
        Type eventType = this.getEventType(runtimeType);
        return EventImpl.createNotifier(runtimeType, eventType, this.qualifiers, ArcContainerImpl.unwrap(Arc.container()));
    }

    static <T> Notifier<T> createNotifier(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers, ArcContainerImpl container) {
        EventMetadataImpl metadata = new EventMetadataImpl(qualifiers, eventType);
        ArrayList notifierObserverMethods = new ArrayList();
        for (ObserverMethod observerMethod : container.resolveObservers(eventType, qualifiers)) {
            notifierObserverMethods.add(observerMethod);
        }
        return new Notifier(runtimeType, notifierObserverMethods, metadata);
    }

    private Type getEventType(Class<?> runtimeType) {
        Type resolvedType = runtimeType;
        if (Types.containsTypeVariable(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsTypeVariable(resolvedType)) {
            Type canonicalEventType = Types.getCanonicalType(runtimeType);
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(canonicalEventType).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(canonicalEventType);
        }
        return resolvedType;
    }

    private void handleExceptions(ObserverExceptionHandler handler) {
        List<Throwable> handledExceptions = handler.getHandledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = null;
            exception = handledExceptions.size() == 1 ? new CompletionException(handledExceptions.get(0)) : new CompletionException(null);
            for (Throwable handledException : handledExceptions) {
                exception.addSuppressed(handledException);
            }
            throw exception;
        }
    }

    static class CollectingExceptionHandler
    implements ObserverExceptionHandler {
        private List<Throwable> throwables;

        CollectingExceptionHandler() {
            this(new LinkedList<Throwable>());
        }

        CollectingExceptionHandler(List<Throwable> throwables) {
            this.throwables = throwables;
        }

        @Override
        public void handle(Throwable throwable) {
            this.throwables.add(throwable);
        }

        @Override
        public List<Throwable> getHandledExceptions() {
            return this.throwables;
        }
    }

    protected static interface ObserverExceptionHandler {
        public static final ObserverExceptionHandler IMMEDIATE_HANDLER = throwable -> {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new ObserverException(throwable);
        };

        public void handle(Throwable var1);

        default public List<Throwable> getHandledExceptions() {
            return Collections.emptyList();
        }
    }

    static class EventMetadataImpl
    implements EventMetadata {
        private final Set<Annotation> qualifiers;
        private final Type eventType;

        public EventMetadataImpl(Set<Annotation> qualifiers, Type eventType) {
            this.qualifiers = qualifiers;
            this.eventType = eventType;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public InjectionPoint getInjectionPoint() {
            return null;
        }

        public Type getType() {
            return this.eventType;
        }
    }

    static class EventContextImpl<T>
    implements EventContext<T> {
        private final T payload;
        private final EventMetadata metadata;

        public EventContextImpl(T payload, EventMetadata metadata) {
            this.payload = payload;
            this.metadata = metadata;
        }

        public T getEvent() {
            return this.payload;
        }

        public EventMetadata getMetadata() {
            return this.metadata;
        }
    }

    static class Notifier<T> {
        private final Class<?> runtimeType;
        private final List<ObserverMethod<? super T>> observerMethods;
        private final EventMetadata eventMetadata;

        Notifier(Class<?> runtimeType, List<ObserverMethod<? super T>> observerMethods, EventMetadata eventMetadata) {
            this.runtimeType = runtimeType;
            this.observerMethods = observerMethods;
            this.eventMetadata = eventMetadata;
        }

        void notify(T event) {
            this.notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
        }

        void notify(T event, ObserverExceptionHandler exceptionHandler, boolean async) {
            if (!this.isEmpty()) {
                EventContextImpl<T> eventContext = new EventContextImpl<T>(event, this.eventMetadata);
                for (ObserverMethod<? super T> observerMethod : this.observerMethods) {
                    if (observerMethod.isAsync() != async) continue;
                    try {
                        observerMethod.notify(eventContext);
                    }
                    catch (Throwable e) {
                        exceptionHandler.handle(e);
                    }
                }
            }
        }

        boolean isEmpty() {
            return this.observerMethods.isEmpty();
        }
    }
}

