/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.TypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

class EventObjectTypeResolverBuilder {
    private final Map<TypeVariable<?>, Type> selectedTypeVariables;
    private final Map<TypeVariable<?>, Type> eventTypeVariables;
    private final Map<TypeVariable<?>, Type> resolvedTypes;

    public EventObjectTypeResolverBuilder(Map<TypeVariable<?>, Type> selectedTypeVariables, Map<TypeVariable<?>, Type> eventTypeVariables) {
        this.selectedTypeVariables = selectedTypeVariables;
        this.eventTypeVariables = eventTypeVariables;
        this.resolvedTypes = new HashMap();
    }

    public TypeResolver build() {
        this.resolveTypeVariables();
        HashMap mergedVariables = new HashMap(this.eventTypeVariables);
        mergedVariables.putAll(this.selectedTypeVariables);
        mergedVariables.putAll(this.resolvedTypes);
        return new TypeResolver(mergedVariables);
    }

    protected void resolveTypeVariables() {
        for (Map.Entry<TypeVariable<?>, Type> entry : this.eventTypeVariables.entrySet()) {
            TypeVariable<?> key = entry.getKey();
            Type typeWithTypeVariables = entry.getValue();
            Type value = this.selectedTypeVariables.get(key);
            if (value == null) continue;
            this.resolveTypeVariables(typeWithTypeVariables, value);
        }
    }

    protected void resolveTypeVariables(Type type1, Type type2) {
        if (type1 instanceof TypeVariable) {
            this.resolveTypeVariables((TypeVariable)type1, type2);
        }
        if (type1 instanceof ParameterizedType) {
            this.resolveTypeVariables((ParameterizedType)type1, type2);
        }
    }

    protected void resolveTypeVariables(TypeVariable<?> type1, Type type2) {
        if (type2 instanceof TypeVariable) {
            return;
        }
        this.resolvedTypes.put(type1, type2);
    }

    protected void resolveTypeVariables(ParameterizedType type1, Type type2) {
        Type[] type2Arguments;
        Type[] type1Arguments;
        if (type2 instanceof ParameterizedType && (type1Arguments = type1.getActualTypeArguments()).length == (type2Arguments = ((ParameterizedType)type2).getActualTypeArguments()).length) {
            for (int i = 0; i < type1Arguments.length; ++i) {
                this.resolveTypeVariables(type1Arguments[i], type2Arguments[i]);
            }
        }
    }

    public Map<TypeVariable<?>, Type> getResolvedTypes() {
        return this.resolvedTypes;
    }
}

