/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ArcContainerImpl;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.CreationalContextImpl;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Provider;

class InstanceImpl<T>
implements Instance<T> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Type type;
    private final Set<Annotation> qualifiers;
    private final CreationalContextImpl<?> creationalContext;
    private final Set<InjectableBean<?>> beans;

    InstanceImpl(Type type, Set<Annotation> qualifiers, CreationalContextImpl<?> creationalContext) {
        ParameterizedType parameterizedType;
        this.type = type instanceof ParameterizedType ? (Provider.class.isAssignableFrom(Types.getRawType((parameterizedType = (ParameterizedType)type).getRawType())) ? parameterizedType.getActualTypeArguments()[0] : type) : type;
        this.qualifiers = qualifiers != null ? qualifiers : Collections.emptySet();
        this.creationalContext = creationalContext;
        this.beans = this.qualifiers.isEmpty() && Object.class.equals((Object)type) ? null : this.resolve();
    }

    public Iterator<T> iterator() {
        return new InstanceIterator(this.beans());
    }

    public T get() {
        Set<InjectableBean<?>> beans = this.beans();
        if (beans.isEmpty()) {
            throw new UnsatisfiedResolutionException();
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException();
        }
        return (T)this.getBeanInstance(beans.iterator().next());
    }

    public Instance<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this.type, newQualifiers, this.creationalContext);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(subtype, newQualifiers, this.creationalContext);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(subtype.getType(), newQualifiers, this.creationalContext);
    }

    public boolean isUnsatisfied() {
        return this.beans().isEmpty();
    }

    public boolean isAmbiguous() {
        return this.beans().size() > 1;
    }

    public void destroy(T instance) {
        if (instance instanceof ClientProxy) {
            throw new UnsupportedOperationException();
        }
        this.creationalContext.destroyDependentInstance(instance);
    }

    void destroy() {
        this.creationalContext.release();
    }

    private T getBeanInstance(InjectableBean<T> bean) {
        CreationalContextImpl ctx = this.creationalContext.child();
        Object instance = bean.get(ctx);
        return (T)instance;
    }

    private Set<InjectableBean<?>> beans() {
        return this.beans != null ? this.beans : this.resolve();
    }

    private Set<InjectableBean<?>> resolve() {
        return ArcContainerImpl.instance().getResolvedBeans(this.type, this.qualifiers.toArray(EMPTY_ANNOTATION_ARRAY));
    }

    class InstanceIterator
    implements Iterator<T> {
        protected final Iterator<InjectableBean<?>> delegate;

        private InstanceIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }
    }
}

