/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;

public class InvocationContextImpl
implements InvocationContext {
    public static final String KEY_INTERCEPTOR_BINDINGS = "io.quarkus.arc.interceptorBindings";
    private final AtomicReference<Object> target;
    private final Method method;
    private final Constructor<?> constructor;
    private Object[] args;
    private int position;
    private final Map<String, Object> contextData;
    private final List<InterceptorInvocation> chain;
    private final Function<InvocationContext, Object> aroundInvokeForward;
    private final Supplier<Object> aroundConstructForward;
    private final Set<Annotation> interceptorBindings;

    public static InvocationContextImpl aroundInvoke(Object target, Method method, Object[] args, List<InterceptorInvocation> chain, Function<InvocationContext, Object> aroundInvokeForward, Set<Annotation> interceptorBindings) {
        return new InvocationContextImpl(target, method, null, args, chain, aroundInvokeForward, null, interceptorBindings);
    }

    public static InvocationContextImpl postConstruct(Object target, List<InterceptorInvocation> chain, Set<Annotation> interceptorBindings) {
        return new InvocationContextImpl(target, null, null, null, chain, null, null, interceptorBindings);
    }

    public static InvocationContextImpl preDestroy(Object target, List<InterceptorInvocation> chain, Set<Annotation> interceptorBindings) {
        return new InvocationContextImpl(target, null, null, null, chain, null, null, interceptorBindings);
    }

    public static InvocationContextImpl aroundConstruct(Constructor<?> constructor, List<InterceptorInvocation> chain, Supplier<Object> aroundConstructForward, Set<Annotation> interceptorBindings) {
        return new InvocationContextImpl(null, null, constructor, null, chain, null, aroundConstructForward, interceptorBindings);
    }

    InvocationContextImpl(Object target, Method method, Constructor<?> constructor, Object[] args, List<InterceptorInvocation> chain, Function<InvocationContext, Object> aroundInvokeForward, Supplier<Object> aroundConstructForward, Set<Annotation> interceptorBindings) {
        this.target = new AtomicReference<Object>(target);
        this.method = method;
        this.constructor = constructor;
        this.args = args;
        this.position = 0;
        this.chain = chain;
        this.aroundInvokeForward = aroundInvokeForward;
        this.aroundConstructForward = aroundConstructForward;
        this.interceptorBindings = interceptorBindings;
        this.contextData = new HashMap<String, Object>();
        this.contextData.put(KEY_INTERCEPTOR_BINDINGS, interceptorBindings);
    }

    boolean hasNextInterceptor() {
        return this.position < this.chain.size();
    }

    protected Object invokeNext() throws Exception {
        int oldPosition = this.position;
        try {
            Object object = this.chain.get(this.position++).invoke(this);
            return object;
        }
        finally {
            this.position = oldPosition;
        }
    }

    protected Object interceptorChainCompleted() throws Exception {
        if (this.aroundInvokeForward != null) {
            return this.aroundInvokeForward.apply(this);
        }
        if (this.aroundConstructForward != null) {
            this.target.set(this.aroundConstructForward.get());
        }
        return null;
    }

    public Object proceed() throws Exception {
        try {
            if (this.hasNextInterceptor()) {
                if (this.aroundConstructForward != null) {
                    this.invokeNext();
                    return this.target.get();
                }
                return this.invokeNext();
            }
            return this.interceptorChainCompleted();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Object getTarget() {
        return this.target.get();
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Object[] getParameters() throws IllegalStateException {
        if (this.args == null) {
            throw new IllegalStateException();
        }
        return this.args;
    }

    public void setParameters(Object[] params) throws IllegalStateException, IllegalArgumentException {
        if (this.args == null) {
            throw new IllegalStateException();
        }
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object getTimer() {
        return null;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public static class InterceptorInvocation {
        private final InterceptionType interceptionType;
        private final InjectableInterceptor interceptor;
        private final Object interceptorInstance;

        public static InterceptorInvocation aroundInvoke(InjectableInterceptor<?> interceptor, Object interceptorInstance) {
            return new InterceptorInvocation(InterceptionType.AROUND_INVOKE, interceptor, interceptorInstance);
        }

        public static InterceptorInvocation postConstruct(InjectableInterceptor<?> interceptor, Object interceptorInstance) {
            return new InterceptorInvocation(InterceptionType.POST_CONSTRUCT, interceptor, interceptorInstance);
        }

        public static InterceptorInvocation preDestroy(InjectableInterceptor<?> interceptor, Object interceptorInstance) {
            return new InterceptorInvocation(InterceptionType.PRE_DESTROY, interceptor, interceptorInstance);
        }

        public static InterceptorInvocation aroundConstruct(InjectableInterceptor<?> interceptor, Object interceptorInstance) {
            return new InterceptorInvocation(InterceptionType.AROUND_CONSTRUCT, interceptor, interceptorInstance);
        }

        InterceptorInvocation(InterceptionType interceptionType, InjectableInterceptor<?> interceptor, Object interceptorInstance) {
            this.interceptionType = interceptionType;
            this.interceptor = interceptor;
            this.interceptorInstance = interceptorInstance;
        }

        Object invoke(InvocationContext ctx) throws Exception {
            return this.interceptor.intercept(this.interceptionType, this.interceptorInstance, ctx);
        }
    }
}

