/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.util.Nonbinding;

public final class Qualifiers {
    public static final Set<Annotation> DEFAULT_QUALIFIERS = Qualifiers.initDefaultQualifiers();

    private Qualifiers() {
    }

    static boolean hasQualifiers(InjectableBean<?> bean, Annotation ... requiredQualifiers) {
        for (Annotation qualifier : requiredQualifiers) {
            if (Qualifiers.hasQualifier(bean, qualifier)) continue;
            return false;
        }
        return true;
    }

    static boolean hasQualifier(InjectableBean<?> bean, Annotation requiredQualifier) {
        Class<? extends Annotation> requiredQualifierClass = requiredQualifier.annotationType();
        Method[] members = requiredQualifierClass.getDeclaredMethods();
        for (Annotation qualifier : bean.getQualifiers()) {
            Class<? extends Annotation> qualifierClass = qualifier.annotationType();
            if (!qualifierClass.equals(requiredQualifier.annotationType())) continue;
            boolean matches = true;
            for (Method value : members) {
                if (value.isAnnotationPresent(Nonbinding.class) || Qualifiers.invoke(value, requiredQualifier).equals(Qualifiers.invoke(value, qualifier))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static boolean hasQualifier(Set<Annotation> qualifiers, Annotation requiredQualifier) {
        Class<? extends Annotation> requiredQualifierClass = requiredQualifier.annotationType();
        Method[] members = requiredQualifierClass.getDeclaredMethods();
        for (Annotation qualifier : qualifiers) {
            Class<? extends Annotation> qualifierClass = qualifier.annotationType();
            if (!qualifierClass.equals(requiredQualifier.annotationType())) continue;
            boolean matches = true;
            for (Method value : members) {
                if (value.isAnnotationPresent(Nonbinding.class) || Qualifiers.invoke(value, requiredQualifier).equals(Qualifiers.invoke(value, qualifier))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    static boolean isSubset(Set<Annotation> observedQualifiers, Set<Annotation> eventQualifiers) {
        for (Annotation required : observedQualifiers) {
            if (Qualifiers.hasQualifier(eventQualifiers, required)) continue;
            return false;
        }
        return true;
    }

    private static Set<Annotation> initDefaultQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)Default.Literal.INSTANCE);
        qualifiers.add((Annotation)Any.Literal.INSTANCE);
        return qualifiers;
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }
}

