/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.ContextInstanceHandleImpl;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

class RequestContext
implements ManagedContext {
    private final ThreadLocal<Map<Contextual<?>, ContextInstanceHandle<?>>> currentContext = new ThreadLocal();

    RequestContext() {
    }

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextInstanceHandle<?> instance = ctx.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextInstanceHandleImpl<Object>((InjectableBean)contextual, contextual.create(creationalContext), creationalContext);
            ctx.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @Override
    public Collection<ContextInstanceHandle<?>> getAll() {
        Map<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return Collections.emptyList();
        }
        return new ArrayList(ctx.values());
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void destroy(Contextual<?> contextual) {
        Map<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextInstanceHandle<?> instance = ctx.remove(contextual);
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public void activate(Collection<ContextInstanceHandle<?>> initialState) {
        HashMap state = new HashMap();
        if (initialState != null) {
            for (ContextInstanceHandle<?> instanceHandle : initialState) {
                if (!instanceHandle.getBean().getScope().equals(this.getScope())) {
                    throw new IllegalArgumentException("Invalid bean scope: " + instanceHandle.getBean());
                }
                state.put(instanceHandle.getBean(), instanceHandle);
            }
        }
        this.currentContext.set(state);
    }

    @Override
    public void deactivate() {
        this.currentContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<Contextual<?>, ContextInstanceHandle<?>> ctx = this.currentContext.get();
        if (ctx != null) {
            Map<Contextual<?>, ContextInstanceHandle<?>> map = ctx;
            synchronized (map) {
                for (InstanceHandle instanceHandle : ctx.values()) {
                    try {
                        instanceHandle.destroy();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to destroy instance" + instanceHandle.get(), e);
                    }
                }
                ctx.clear();
            }
        }
    }
}

