/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project;

import com.gradle.develocity.agent.maven.api.DevelocityApi;
import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.ConfiguredPlugin;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.Log;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public abstract class SimpleQuarkusConfiguredPlugin
implements ConfiguredPlugin {
    @Override
    public void configureBuildCache(DevelocityApi develocityApi, MavenSession mavenSession) {
        develocityApi.getBuildCache().registerMojoMetadataProvider(context -> context.withPlugin(this.getPluginName(), () -> {
            if (!this.isBuildCacheEnabled(context.getProject())) {
                Log.debug(this.getPluginName(), "Build cache is disabled.");
                return;
            }
            Map<String, GoalMetadataProvider> goalMetadataProviders = Collections.unmodifiableMap(this.getGoalMetadataProviders());
            Log.debug(this.getPluginName(), "Build cache is enabled. Configuring metadata providers.");
            Log.debug(this.getPluginName(), "Configuring metadata for goals: " + String.valueOf(goalMetadataProviders.keySet()));
            for (Map.Entry<String, GoalMetadataProvider> goalMetadataProviderEntry : goalMetadataProviders.entrySet()) {
                if (!goalMetadataProviderEntry.getKey().equalsIgnoreCase(context.getMojoExecution().getGoal())) continue;
                goalMetadataProviderEntry.getValue().configure(new GoalMetadataProvider.Context(develocityApi.getBuildScan(), context));
            }
        }));
    }

    protected abstract String getPluginName();

    protected boolean isBuildCacheEnabled(MavenProject project) {
        return true;
    }

    protected abstract Map<String, GoalMetadataProvider> getGoalMetadataProviders();

    protected static void dependsOnGav(MojoMetadataProvider.Context.Inputs inputs, MojoMetadataProvider.Context context) {
        inputs.property("_internal_gav", (Object)(context.getProject().getGroupId() + ":" + context.getProject().getArtifactId() + ":" + context.getProject().getVersion()));
    }

    protected static void dependsOnOs(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("_internal_osName", (Object)System.getProperty("os.name")).property("_internal_osVersion", (Object)System.getProperty("os.version")).property("_internal_osArch", (Object)System.getProperty("os.arch"));
    }

    protected static void dependsOnJavaVersion(MojoMetadataProvider.Context.Inputs inputs) {
        inputs.property("_internal_javaVersion", (Object)System.getProperty("java.version"));
    }

    protected static void addClasspathInput(MojoMetadataProvider.Context context, MojoMetadataProvider.Context.Inputs inputs) {
        try {
            List compileClasspathElements = context.getProject().getCompileClasspathElements();
            inputs.fileSet("quarkusCompileClasspath", (Object)compileClasspathElements, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Classpath can't be resolved");
        }
    }

    protected static void addClasspathInput(MojoMetadataProvider.Context.Inputs inputs, Path classpathFilePath) {
        if (!Files.isReadable(classpathFilePath)) {
            return;
        }
        try {
            List<String> quarkusDependencies = Files.readAllLines(classpathFilePath, StandardCharsets.UTF_8);
            inputs.fileSet("quarkus-dependencies", quarkusDependencies, fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.CLASSPATH));
        }
        catch (IOException e) {
            Log.warn("Unable to add dependencies for " + String.valueOf(classpathFilePath), e);
        }
    }
}

