/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;

public class QuarkusExtensionConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "quarkus-extension-maven-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("extension-descriptor", QuarkusExtensionConfiguredPlugin::configureExtensionDescriptor);
    }

    private static void configureExtensionDescriptor(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            QuarkusExtensionConfiguredPlugin.dependsOnGav(inputs, context.metadata());
            inputs.properties(new String[]{"deployment", "excludedArtifacts", "parentFirstArtifacts", "runnerParentFirstArtifacts", "lesserPriorityArtifacts", "skipExtensionValidation", "ignoreNotDetectedQuarkusCoreVersion", "conditionalDependencies", "dependencyCondition", "skipCodestartValidation", "minimumJavaVersion"});
            inputs.fileSet("extensionFile", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.property("skipExtensionValidation", (Object)context.properties().getBoolean("skipExtensionValidation"));
            inputs.property("skipCodestartValidation", (Object)context.properties().getBoolean("skipCodestartValidation"));
            inputs.ignore(new String[]{"session", "repoSession", "outputDirectory", "project"});
        });
        context.metadata().nested("repos", c -> c.inputs(inputs -> inputs.properties(new String[]{"id", "url"})));
        context.metadata().nested("removedResources", c -> c.inputs(inputs -> inputs.properties(new String[]{"key", "resources"})));
        context.metadata().nested("capabilities", c -> {
            c.nested("requires", cc -> cc.inputs(inputs -> inputs.properties(new String[]{"name", "onlyIf", "onlyIfNot"})));
            c.nested("provides", cc -> cc.inputs(inputs -> inputs.properties(new String[]{"name", "onlyIf", "onlyIfNot"})));
        });
        context.metadata().outputs(outputs -> {
            outputs.cacheable("If the inputs and dependencies are identical, we should have the same output");
            outputs.file("quarkus-extension.yaml", (Object)(context.project().getBuild().getOutputDirectory() + "/META-INF/quarkus-extension.yaml"));
            outputs.file("quarkus-extension.properties", (Object)(context.project().getBuild().getOutputDirectory() + "/META-INF/quarkus-extension.properties"));
        });
    }
}

