/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.develocity.project.plugins;

import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import io.quarkus.develocity.project.GoalMetadataProvider;
import io.quarkus.develocity.project.SimpleQuarkusConfiguredPlugin;
import java.util.Map;
import java.util.stream.Collectors;

public class SourceConfiguredPlugin
extends SimpleQuarkusConfiguredPlugin {
    @Override
    protected String getPluginName() {
        return "maven-source-plugin";
    }

    @Override
    protected Map<String, GoalMetadataProvider> getGoalMetadataProviders() {
        return Map.of("jar-no-fork", SourceConfiguredPlugin::jarNoFork);
    }

    private static void jarNoFork(GoalMetadataProvider.Context context) {
        context.metadata().inputs(inputs -> {
            SourceConfiguredPlugin.dependsOnGav(inputs, context.metadata());
            inputs.properties(new String[]{"classifier", "includes", "excludes", "useDefaultExcludes", "useDefaultManifestFile", "attach", "excludeResources", "includePom", "finalName", "forceCreation", "skipSource", "outputTimestamp"});
            inputs.fileSet("defaultManifestFile", fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("resources", context.project().getResources().stream().map(r -> r.getDirectory()).collect(Collectors.toList()), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.fileSet("sources", (Object)context.project().getCompileSourceRoots(), fileSet -> fileSet.normalizationStrategy(MojoMetadataProvider.Context.FileSet.NormalizationStrategy.RELATIVE_PATH));
            inputs.ignore(new String[]{"project", "jarArchiver", "archive", "outputDirectory", "reactorProjects", "session"});
        });
        context.metadata().outputs(outputs -> {
            outputs.cacheable("If the inputs are identical, we should have the same output");
            outputs.file("source-jar", (Object)(context.project().getBuild().getDirectory() + "/" + context.project().getBuild().getFinalName() + "-sources.jar"));
        });
    }
}

