/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.QuarkusCliClient;
import io.quarkus.test.bootstrap.RestService;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public class QuarkusCliRestService
extends RestService {
    private final QuarkusCliClient cliClient;

    public QuarkusCliRestService(QuarkusCliClient cliClient) {
        this.cliClient = cliClient;
    }

    public QuarkusCliClient.Result buildOnJvm(String ... extraArgs) {
        return this.cliClient.buildApplicationOnJvm(this.getServiceFolder(), extraArgs);
    }

    public QuarkusCliClient.Result buildOnNative(String ... extraArgs) {
        return this.cliClient.buildApplicationOnNative(this.getServiceFolder(), extraArgs);
    }

    public QuarkusCliClient.Result installExtension(String extension) {
        return this.cliClient.run(this.getServiceFolder(), "extension", "add", extension);
    }

    public QuarkusCliClient.Result removeExtension(String extension) {
        return this.cliClient.run(this.getServiceFolder(), "extension", "remove", extension);
    }

    public List<String> getInstalledExtensions() {
        QuarkusCliClient.Result result = this.cliClient.run(this.getServiceFolder(), "extension", "list", "--id");
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Extension list failed");
        return result.getOutput().lines().map(String::trim).map(line -> line.replace("\u272c ", "")).collect(Collectors.toList());
    }
}

