/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.QuarkusCliClient;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.logging.FileServiceLoggingHandler;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.scenarios.annotations.DisabledOnQuarkusSnapshotCondition;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.ProcessUtils;
import io.quarkus.test.utils.SocketUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CliDevModeLocalhostQuarkusApplicationManagedResource
extends QuarkusManagedResource {
    private static final String QUARKUS_HTTP_PORT_PROPERTY = "quarkus.http.port";
    private static final String QUARKUS_PLATFORM_ARTIFACT_ID = "quarkus.platform.artifact-id";
    private static final String QUARKUS_PLATFORM_ARTIFACT_ID_VALUE = "quarkus-bom";
    private static final String QUARKUS_PLATFORM_VERSION = "quarkus.platform.version";
    private final ServiceContext serviceContext;
    private final QuarkusCliClient client;
    private Process process;
    private LoggingHandler loggingHandler;
    private int assignedHttpPort;

    public CliDevModeLocalhostQuarkusApplicationManagedResource(ServiceContext serviceContext, QuarkusCliClient client) {
        super(serviceContext);
        this.serviceContext = serviceContext;
        this.client = client;
    }

    public void start() {
        if (this.process != null && this.process.isAlive()) {
            return;
        }
        try {
            this.assignPorts();
            File logFile = this.serviceContext.getServiceFolder().resolve("quarkus-cli-dev.out").toFile();
            this.process = this.client.runOnDev(this.serviceContext.getServiceFolder(), logFile, this.getPropertiesForCommand());
            this.loggingHandler = new FileServiceLoggingHandler(this.serviceContext.getOwner(), logFile);
            this.loggingHandler.startWatching();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
            File logFile = this.serviceContext.getServiceFolder().resolve("quarkus-cli-dev.out").toFile();
            FileUtils.deleteFileContent((File)logFile);
        }
        ProcessUtils.destroy((Process)this.process);
    }

    public URILike getURI(Protocol protocol) {
        return this.createURI(protocol.getValue(), "localhost", this.assignedHttpPort);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public boolean isRunning() {
        return this.process != null && this.process.isAlive() && super.isRunning();
    }

    protected LaunchMode getLaunchMode() {
        return LaunchMode.DEV;
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private Map<String, String> getPropertiesForCommand() {
        HashMap<String, String> runtimeProperties = new HashMap<String, String>(this.serviceContext.getOwner().getProperties());
        runtimeProperties.putIfAbsent(QUARKUS_HTTP_PORT_PROPERTY, "" + this.assignedHttpPort);
        runtimeProperties.putIfAbsent(QUARKUS_PLATFORM_VERSION, QuarkusProperties.getVersion());
        if (DisabledOnQuarkusSnapshotCondition.isQuarkusSnapshotVersion()) {
            runtimeProperties.putIfAbsent(QuarkusProperties.PLATFORM_GROUP_ID.getPropertyKey(), QuarkusProperties.PLATFORM_GROUP_ID.get());
            runtimeProperties.putIfAbsent(QUARKUS_PLATFORM_ARTIFACT_ID, QUARKUS_PLATFORM_ARTIFACT_ID_VALUE);
        }
        return runtimeProperties;
    }

    private void assignPorts() {
        this.assignedHttpPort = this.getOrAssignPortByProperty(QUARKUS_HTTP_PORT_PROPERTY);
    }

    private int getOrAssignPortByProperty(String property) {
        return this.serviceContext.getOwner().getProperty(property).filter(str -> !str.isEmpty()).map(Integer::parseInt).orElseGet(SocketUtils::findAvailablePort);
    }
}

