/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.QuarkusCliDefaultService;
import io.quarkus.test.bootstrap.QuarkusCliRestService;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.FileLoggingHandler;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.quarkus.CliDevModeLocalhostQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.ProcessBuilderProvider;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public class QuarkusCliClient {
    public static final String COMMAND_LOG_FILE = "quarkus-cli-command.out";
    public static final String DEV_MODE_LOG_FILE = "quarkus-cli-dev.out";
    private static final String BUILD = "build";
    private static final PropertyLookup COMMAND = new PropertyLookup("ts.quarkus.cli.cmd", "quarkus");
    private static final Path TARGET = Paths.get("target", new String[0]);
    private final ScenarioContext context;

    public QuarkusCliClient(ScenarioContext context) {
        this.context = context;
    }

    public Result run(Path servicePath, String ... args) {
        return this.runCliAndWait(servicePath, args);
    }

    public Result run(String ... args) {
        return this.runCliAndWait(args);
    }

    public Result buildApplicationOnJvm(Path serviceFolder, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(BUILD);
        args.addAll(Arrays.asList(extraArgs));
        return this.runCliAndWait(serviceFolder, args.toArray(new String[args.size()]));
    }

    public Result buildApplicationOnNative(Path serviceFolder, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(BUILD);
        args.add("--native");
        args.addAll(Arrays.asList(extraArgs));
        return this.runCliAndWait(serviceFolder, args.toArray(new String[args.size()]));
    }

    public Process runOnDev(Path servicePath, File logOutput, Map<String, String> arguments) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("dev");
        cmd.addAll(arguments.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()));
        return this.runCli(servicePath, logOutput, cmd.toArray(new String[cmd.size()]));
    }

    public QuarkusCliRestService createApplication(String name) {
        return this.createApplication(name, CreateApplicationRequest.defaults());
    }

    public QuarkusCliRestService createApplication(String name, CreateApplicationRequest request) {
        QuarkusCliRestService service = new QuarkusCliRestService(this);
        ServiceContext serviceContext = service.register(name, this.context);
        service.init(s -> new CliDevModeLocalhostQuarkusApplicationManagedResource(serviceContext, this));
        FileUtils.deletePath((Path)serviceContext.getServiceFolder());
        ArrayList<Object> args = new ArrayList<Object>();
        args.addAll(Arrays.asList("create", "app", name));
        if (QuarkusCliClient.isNotEmpty(request.platformBom)) {
            args.add("--platform-bom=" + request.platformBom);
        }
        if (QuarkusCliClient.isNotEmpty(request.stream)) {
            args.add("--stream=" + request.stream);
        }
        if (request.extensions != null && request.extensions.length > 0) {
            args.add("-x=" + Stream.of(request.extensions).collect(Collectors.joining(",")));
        }
        if (request.extraArgs != null && request.extraArgs.length > 0) {
            Stream.of(request.extraArgs).forEach(args::add);
        }
        Result result = this.runCliAndWait(serviceContext.getServiceFolder().getParent(), args.toArray(new String[args.size()]));
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)("The application was not created. Output: " + result.getOutput()));
        return service;
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public QuarkusCliDefaultService createExtension(String name) {
        return this.createExtension(name, CreateExtensionRequest.defaults());
    }

    public QuarkusCliDefaultService createExtension(String name, CreateExtensionRequest request) {
        QuarkusCliDefaultService service = new QuarkusCliDefaultService(this);
        ServiceContext serviceContext = service.register("quarkus-" + name, this.context);
        FileUtils.createDirectory((Path)serviceContext.getServiceFolder().getParent());
        ArrayList<Object> args = new ArrayList<Object>();
        args.addAll(Arrays.asList("create", "extension", name));
        if (QuarkusCliClient.isNotEmpty(request.platformBom)) {
            args.add("--platform-bom=" + request.platformBom);
        }
        if (QuarkusCliClient.isNotEmpty(request.stream)) {
            args.add("--stream=" + request.stream);
        }
        if (request.extraArgs != null && request.extraArgs.length > 0) {
            Stream.of(request.extraArgs).forEach(args::add);
        }
        Result result = this.runCliAndWait(serviceContext.getServiceFolder().getParent(), args.toArray(new String[args.size()]));
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)("The extension was not created. Output: " + result.getOutput()));
        return service;
    }

    private Result runCliAndWait(String ... args) {
        return this.runCliAndWait(TARGET, args);
    }

    private Result runCliAndWait(Path workingDirectory, String ... args) {
        Result result = new Result();
        File output = workingDirectory.resolve(COMMAND_LOG_FILE).toFile();
        try (FileLoggingHandler loggingHandler = new FileLoggingHandler(output);){
            loggingHandler.startWatching();
            Process process = this.runCli(workingDirectory, output, args);
            result.exitCode = process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.warn((String)("Failed to run Quarkus CLI command. Caused by: " + e.getMessage()), (Object[])new Object[0]);
            result.exitCode = 1;
        }
        result.output = FileUtils.loadFile((File)output).trim();
        FileUtils.deleteFileContent((File)output);
        return result;
    }

    private Process runCli(Path workingDirectory, File logOutput, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(COMMAND.get().split(" ")));
        cmd.addAll(Arrays.asList(args));
        if (QuarkusProperties.disableBuildAnalytics()) {
            cmd.add(String.format("-D%s=%s", "quarkus.analytics.disabled", Boolean.TRUE));
        }
        Log.info((String)cmd.stream().collect(Collectors.joining(" ")), (Object[])new Object[0]);
        try {
            return ProcessBuilderProvider.command(cmd).redirectErrorStream(true).redirectOutput(logOutput).directory(workingDirectory.toFile()).start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Result {
        private static final int EXIT_SUCCESS = 0;
        int exitCode;
        String output;

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isSuccessful() {
            return 0 == this.exitCode;
        }
    }

    public static class CreateExtensionRequest {
        private String platformBom;
        private String stream;
        private String[] extraArgs;

        public CreateExtensionRequest withPlatformBom(String platformBom) {
            this.platformBom = platformBom;
            return this;
        }

        public CreateExtensionRequest withStream(String stream) {
            this.stream = stream;
            return this;
        }

        public CreateExtensionRequest withExtraArgs(String ... extraArgs) {
            this.extraArgs = extraArgs;
            return this;
        }

        public static CreateExtensionRequest defaults() {
            return new CreateExtensionRequest().withStream("3.2");
        }
    }

    public static class CreateApplicationRequest {
        private String platformBom;
        private String stream;
        private String[] extensions;
        private String[] extraArgs;

        public CreateApplicationRequest withPlatformBom(String platformBom) {
            this.platformBom = platformBom;
            return this;
        }

        public CreateApplicationRequest withStream(String stream) {
            this.stream = stream;
            return this;
        }

        public CreateApplicationRequest withExtensions(String ... extensions) {
            this.extensions = extensions;
            return this;
        }

        public CreateApplicationRequest withExtraArgs(String ... extraArgs) {
            this.extraArgs = extraArgs;
            return this;
        }

        public static CreateApplicationRequest defaults() {
            return new CreateApplicationRequest().withStream("3.2");
        }
    }
}

