/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.Container;
import io.quarkus.test.services.containers.ContainerManagedResourceBinding;
import io.quarkus.test.services.containers.GenericDockerContainerManagedResource;
import io.quarkus.test.utils.PropertiesUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.ServiceLoader;

public class ContainerManagedResourceBuilder
implements ManagedResourceBuilder {
    private final ServiceLoader<ContainerManagedResourceBinding> managedResourceBindingsRegistry = ServiceLoader.load(ContainerManagedResourceBinding.class);
    private ServiceContext context;
    private String image;
    private String expectedLog;
    private String[] command;
    private Integer port;

    protected String getImage() {
        return this.image;
    }

    protected String getExpectedLog() {
        return this.expectedLog;
    }

    protected String[] getCommand() {
        return Optional.ofNullable(this.command).orElse(new String[0]);
    }

    protected Integer getPort() {
        return this.port;
    }

    protected ServiceContext getContext() {
        return this.context;
    }

    public void init(Annotation annotation) {
        Container metadata = (Container)annotation;
        this.image = PropertiesUtils.resolveProperty((String)metadata.image());
        this.command = metadata.command();
        this.expectedLog = PropertiesUtils.resolveProperty((String)metadata.expectedLog());
        this.port = metadata.port();
    }

    public ManagedResource build(ServiceContext context) {
        this.context = context;
        for (ContainerManagedResourceBinding binding : this.managedResourceBindingsRegistry) {
            if (!binding.appliesFor(context)) continue;
            return binding.init(this);
        }
        return new GenericDockerContainerManagedResource(this);
    }
}

