/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.LocalhostManagedResource;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.Container;
import io.quarkus.test.services.containers.ContainerManagedResourceBinding;
import io.quarkus.test.services.containers.GenericDockerContainerManagedResource;
import io.quarkus.test.utils.PropertiesUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class ContainerManagedResourceBuilder
implements ManagedResourceBuilder {
    private final ServiceLoader<ContainerManagedResourceBinding> managedResourceBindingsRegistry = ServiceLoader.load(ContainerManagedResourceBinding.class);
    private ServiceContext context;
    private String image;
    private String expectedLog;
    private String[] command;
    private List<MountConfig> mounts = new ArrayList<MountConfig>();
    private Integer port;
    private boolean portDockerHostToLocalhost;

    protected String getImage() {
        return this.image;
    }

    protected String getExpectedLog() {
        return this.expectedLog;
    }

    protected String[] getCommand() {
        return Optional.ofNullable(this.command).orElse(new String[0]);
    }

    protected Integer getPort() {
        return this.port;
    }

    protected ServiceContext getContext() {
        return this.context;
    }

    public void init(Annotation annotation) {
        Container metadata = (Container)annotation;
        this.init(metadata.image(), metadata.command(), metadata.expectedLog(), metadata.port(), metadata.portDockerHostToLocalhost());
        this.mounts = ((Stream)Arrays.stream(metadata.mounts()).sequential()).map(mount -> new MountConfig(mount.from(), mount.to())).toList();
    }

    protected void init(String image, String[] command, String expectedLog, int port, boolean portDockerHostToLocalhost) {
        this.image = PropertiesUtils.resolveProperty((String)image);
        this.command = command;
        this.expectedLog = PropertiesUtils.resolveProperty((String)expectedLog);
        this.port = port;
        this.portDockerHostToLocalhost = portDockerHostToLocalhost;
    }

    public ManagedResource build(ServiceContext context) {
        this.context = context;
        for (ContainerManagedResourceBinding binding : this.managedResourceBindingsRegistry) {
            if (!binding.appliesFor(context)) continue;
            if (this.portDockerHostToLocalhost) {
                return new LocalhostManagedResource(binding.init(this));
            }
            return binding.init(this);
        }
        if (this.portDockerHostToLocalhost) {
            return new LocalhostManagedResource((ManagedResource)new GenericDockerContainerManagedResource(this));
        }
        return new GenericDockerContainerManagedResource(this);
    }

    public List<MountConfig> getMounts() {
        return this.mounts;
    }

    class MountConfig {
        final String from;
        final String to;

        MountConfig(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

