/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.BaseService;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.logging.Log;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.TestContainersLoggingHandler;
import io.quarkus.test.services.URILike;
import io.quarkus.test.utils.DockerUtils;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.MountableFile;

public abstract class DockerContainerManagedResource
implements ManagedResource {
    public static final String DOCKER_INNER_CONTAINER = DockerContainerManagedResource.class.getName() + "_inner";
    private static final String TARGET = "target";
    private final ServiceContext context;
    private GenericContainer<?> innerContainer;
    private LoggingHandler loggingHandler;

    protected DockerContainerManagedResource(ServiceContext context) {
        this.context = context;
    }

    protected abstract int getTargetPort();

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.innerContainer = this.initContainer();
        if (this.isDockerImageDeletedOnStop()) {
            String image = (String)this.innerContainer.getImage().get();
            DockerUtils.pullImageById((String)image);
        }
        Configuration configuration = this.context.getOwner().getConfiguration();
        this.innerContainer.withStartupTimeout(configuration.getAsDuration(Configuration.Property.SERVICE_STARTUP_TIMEOUT, BaseService.SERVICE_STARTUP_TIMEOUT_DEFAULT));
        this.innerContainer.withEnv(this.resolveProperties());
        this.innerContainer.withStartupAttempts(configuration.getAsInteger(Configuration.Property.CONTAINER_STARTUP_ATTEMPTS, 1));
        this.loggingHandler = new TestContainersLoggingHandler(this.context.getOwner(), this.innerContainer);
        this.loggingHandler.startWatching();
        this.doStart();
        this.context.put(DOCKER_INNER_CONTAINER, this.innerContainer);
    }

    private boolean isDockerImageDeletedOnStop() {
        return this.context.getOwner().getConfiguration().isTrue(Configuration.Property.DELETE_IMAGE_ON_STOP_PROPERTY);
    }

    protected abstract GenericContainer<?> initContainer();

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        String image = (String)this.innerContainer.getImage().get();
        if (this.isRunning()) {
            this.innerContainer.stop();
            this.innerContainer = null;
        }
        if (this.isDockerImageDeletedOnStop()) {
            DockerUtils.removeImageById((String)image);
        }
    }

    public URILike getURI(Protocol protocol) {
        return this.createURI(protocol.getValue(), this.innerContainer.getHost(), this.getMappedPort(this.getTargetPort()));
    }

    public boolean isRunning() {
        return this.innerContainer != null && this.innerContainer.isRunning();
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    protected int getMappedPort(int port) {
        return this.innerContainer.getMappedPort(port);
    }

    private void doStart() {
        try {
            this.innerContainer.start();
        }
        catch (Exception ex) {
            this.stop();
            this.loggingHandler.logs().forEach(x$0 -> Log.info((String)x$0, (Object[])new Object[0]));
            throw ex;
        }
    }

    private Map<String, String> resolveProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : this.context.getOwner().getProperties().entrySet()) {
            String value = (String)entry.getValue();
            if (this.isResource((String)entry.getValue())) {
                value = ((String)entry.getValue()).replace("resource::/", "");
                this.addFileToContainer(value);
            } else if (DockerContainerManagedResource.isSecretWithDestinationPath((String)entry.getValue())) {
                value = ((String)entry.getValue()).replace("secret_with_destination::", "");
                destinationPath = value.split("\\|")[0];
                fileName = value.split("\\|")[1];
                this.addFileToContainer(destinationPath, fileName);
                value = value.replace("|", "");
            } else if (this.isResourceWithDestinationPath((String)entry.getValue())) {
                value = ((String)entry.getValue()).replace("resource_with_destination::", "");
                if (!value.matches(".*\\|.*")) {
                    String errorMsg = String.format("Unexpected %s format. Expected destinationPath|fileName but found %s", "resource_with_destination::", value);
                    throw new RuntimeException(errorMsg);
                }
                destinationPath = value.split("\\|")[0];
                fileName = value.split("\\|")[1];
                this.addFileToContainer(destinationPath, fileName);
                value = value.replace("|", "");
            } else if (this.isSecret((String)entry.getValue())) {
                value = ((String)entry.getValue()).replace("secret::/", "");
                this.addFileToContainer(value);
            }
            properties.put((String)entry.getKey(), value);
        }
        return properties;
    }

    private void addFileToContainer(String path) {
        Path filePath = Path.of(TARGET, path);
        if (Files.exists(filePath, new LinkOption[0])) {
            this.innerContainer.withCopyFileToContainer(MountableFile.forHostPath((Path)filePath), path);
        } else {
            this.innerContainer.withClasspathResourceMapping(path, path, BindMode.READ_ONLY);
        }
    }

    private void addFileToContainer(String destinationPath, String hostFilePath) {
        Optional filePath = FileUtils.findTargetFile((Path)Path.of(TARGET, new String[0]), (String)hostFilePath);
        String containerFullPath = destinationPath + PropertiesUtils.SLASH + hostFilePath;
        if (filePath.isEmpty()) {
            this.innerContainer.withClasspathResourceMapping(hostFilePath, containerFullPath, BindMode.READ_ONLY);
        } else {
            this.innerContainer.withCopyFileToContainer(MountableFile.forHostPath((String)((String)filePath.get())), containerFullPath);
        }
    }

    private static boolean isSecretWithDestinationPath(String key) {
        return key.startsWith("secret_with_destination::");
    }

    private boolean isResourceWithDestinationPath(String key) {
        return key.startsWith("resource_with_destination::");
    }

    private boolean isResource(String key) {
        return key.startsWith("resource::/");
    }

    private boolean isSecret(String key) {
        return key.startsWith("secret::/");
    }
}

