/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import io.quarkus.test.services.containers.DockerContainerManagedResource;
import io.quarkus.test.utils.DockerUtils;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class GenericDockerContainerManagedResource
extends DockerContainerManagedResource {
    private final ContainerManagedResourceBuilder model;

    protected GenericDockerContainerManagedResource(ContainerManagedResourceBuilder model) {
        super(model.getContext());
        this.model = model;
    }

    public String getDisplayName() {
        return this.model.getImage();
    }

    @Override
    protected int getTargetPort() {
        return this.model.getPort();
    }

    @Override
    protected GenericContainer<?> initContainer() {
        GenericContainer container = new GenericContainer(this.model.getImage());
        if (StringUtils.isNotBlank((CharSequence)this.model.getExpectedLog())) {
            container.waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*" + this.model.getExpectedLog() + ".*\\s"));
        }
        if (this.model.getCommand() != null && this.model.getCommand().length > 0) {
            container.withCommand(this.model.getCommand());
        }
        if (this.isPrivileged()) {
            Log.info((Service)this.model.getContext().getOwner(), (String)"Running container on Privileged mode", (Object[])new Object[0]);
            container.setPrivilegedMode(true);
        }
        container.withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
        if (this.isReusable()) {
            Log.info((Service)this.model.getContext().getOwner(), (String)"Running container on Reusable mode", (Object[])new Object[0]);
            Log.warn((Service)this.model.getContext().getOwner(), (String)"Reusable mode expose testcontainers 'withReuse' method that is tagged as UnstableAPI, so is a subject to change and SHOULD NOT be considered a stable API", (Object[])new Object[0]);
            container.withReuse(true);
        }
        for (ContainerManagedResourceBuilder.MountConfig mount : this.model.getMounts()) {
            try {
                URL resource = this.getClass().getClassLoader().getResource(mount.from);
                Path source = Paths.get(resource.toURI());
                Log.info((Service)this.model.getContext().getOwner(), (String)("Mounting " + String.valueOf(source) + " to " + mount.to), (Object[])new Object[0]);
                container.addFileSystemBind(source.toString(), mount.to, BindMode.READ_ONLY, SelinuxContext.SHARED);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        container.withExposedPorts(new Integer[]{this.model.getPort()});
        return container;
    }

    @Override
    public void stop() {
        if (!this.isReusable()) {
            super.stop();
        }
    }

    protected boolean isReusable() {
        return this.model.getContext().getOwner().getConfiguration().isTrue(Configuration.Property.REUSABLE_MODE);
    }

    private boolean isPrivileged() {
        return this.model.getContext().getOwner().getConfiguration().isTrue(Configuration.Property.PRIVILEGED_MODE);
    }
}

