/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class DockerUtils {
    public static final String CONTAINER_REGISTRY_URL_PROPERTY = "ts.container.registry-url";
    private static final String CONTAINER_PREFIX = "ts.global.docker-container-prefix";
    private static final String DOCKERFILE = "Dockerfile";
    private static final String DOCKERFILE_TEMPLATE = "/Dockerfile.%s";
    private static final String DOCKER = "docker";
    private static final Object LOCK = new Object();
    private static final Random RANDOM = new Random();
    private static DockerClient dockerClientInstance;

    private DockerUtils() {
    }

    public static String getDockerfile(LaunchMode mode) {
        return String.format(DOCKERFILE_TEMPLATE, mode.getName());
    }

    public static String createImageAndPush(ServiceContext service, LaunchMode mode, Path artifact) {
        DockerUtils.validateContainerRegistry();
        Path target = DockerUtils.getTargetFolder(mode, artifact);
        String dockerfileContent = FileUtils.loadFile((String)DockerUtils.getDockerfile(mode)).replaceAll(Pattern.quote("${ARTIFACT_PARENT}"), target.toString());
        Path dockerfilePath = FileUtils.copyContentTo((String)dockerfileContent, (Path)service.getServiceFolder().resolve(DOCKERFILE));
        DockerUtils.buildService(service, dockerfilePath);
        return DockerUtils.pushToContainerRegistryUrl(service);
    }

    public static boolean isVersion(Image image, String expectedVersion) {
        String[] tags;
        boolean exist = false;
        for (String tag : tags = Optional.ofNullable(image.getRepoTags()).orElse(new String[0])) {
            if (!tag.contains(expectedVersion)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static boolean removeImage(String name, String version) {
        boolean removed = false;
        Image image = DockerUtils.getImage(name, version);
        if (DockerUtils.isVersion(image, version)) {
            DockerUtils.stopContainersByImage(image.getId());
            DockerUtils.removeImageById(image.getId());
            removed = true;
        }
        return removed;
    }

    public static void removeImageById(String imageId) {
        DockerUtils.dockerClient().removeImageCmd(imageId).withForce(Boolean.valueOf(true)).exec();
    }

    public static void stopContainersByImage(String imageId) {
        List containers = (List)DockerUtils.dockerClient().listContainersCmd().withAncestorFilter(Arrays.asList(imageId)).exec();
        for (Container container : containers) {
            DockerUtils.dockerClient().stopContainerCmd(container.getId()).exec();
        }
    }

    public static Image getImage(String name, String version) {
        Image result = new Image();
        List images = (List)DockerUtils.dockerClient().listImagesCmd().withImageNameFilter(name).exec();
        for (Image image : images) {
            if (!DockerUtils.isVersion(image, version)) continue;
            result = image;
            break;
        }
        return result;
    }

    public static String generateDockerContainerName() {
        String containerName = "" + (RANDOM.nextInt() & Integer.MAX_VALUE);
        String dockerContainerPrefix = System.getProperty(CONTAINER_PREFIX);
        if (Objects.nonNull(dockerContainerPrefix)) {
            containerName = dockerContainerPrefix + "-" + containerName;
        }
        return containerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DockerClient dockerClient() {
        if (dockerClientInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (dockerClientInstance == null) {
                    DefaultDockerClientConfig dockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
                    ZerodepDockerHttpClient dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(dockerClientConfig.getDockerHost()).sslConfig((SSLConfig)dockerClientConfig.getSSLConfig()).build();
                    dockerClientInstance = DockerClientImpl.getInstance((DockerClientConfig)dockerClientConfig, (DockerHttpClient)dockerHttpClient);
                }
            }
        }
        return dockerClientInstance;
    }

    private static void validateContainerRegistry() {
        if (StringUtils.isEmpty((CharSequence)System.getProperty(CONTAINER_REGISTRY_URL_PROPERTY))) {
            Assertions.fail((String)"Container Registry URL is not provided, use -Dts.container.registry-url=XXX");
        }
    }

    private static void buildService(ServiceContext service, Path dockerFile) {
        try {
            new Command(new String[]{DOCKER, "build", "-f", dockerFile.toString(), "-t", DockerUtils.getUniqueName(service), "."}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to build image " + service.getServiceFolder().toAbsolutePath().toString() + " . Caused by " + e.getMessage()));
        }
    }

    private static String pushToContainerRegistryUrl(ServiceContext service) {
        String containerRegistryUrl = System.getProperty(CONTAINER_REGISTRY_URL_PROPERTY);
        try {
            String targetImage = containerRegistryUrl + "/" + DockerUtils.getUniqueName(service);
            new Command(new String[]{DOCKER, "tag", DockerUtils.getUniqueName(service), targetImage}).runAndWait();
            new Command(new String[]{DOCKER, "push", targetImage}).runAndWait();
            return targetImage;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to push image " + service.getOwner().getName() + " into " + containerRegistryUrl + ". Caused by " + e.getMessage()));
            return null;
        }
    }

    private static String getUniqueName(ServiceContext service) {
        String uniqueName = service.getTestContext().getRequiredTestClass().getName() + "." + service.getName();
        return uniqueName.toLowerCase();
    }

    private static Path getTargetFolder(LaunchMode mode, Path artifact) {
        Path target = artifact.getParent();
        if (mode == LaunchMode.JVM) {
            target = target.getParent();
        }
        return target;
    }
}

