/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import com.google.common.base.Strings;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class DockerUtils {
    private static final String DOCKERFILE = "Dockerfile";
    private static final String DOCKERFILE_TEMPLATE = "/Dockerfile.%s";
    private static final String DOCKERFILE_COMPATIBILITY_TEMPLATE = "/Dockerfile-compatibility.%s";
    private static final Integer DOCKER_PULL_TIMEOUT_SEC = 120;
    private static final String DOCKER = "docker";
    private static final Object LOCK = new Object();
    private static final Random RANDOM = new Random();
    private static final String TEST_UBI8_COMPATIBILITY = "test-ubi8-compatibility";
    private static DockerClient dockerClientInstance;

    private DockerUtils() {
    }

    public static String getDockerfile(LaunchMode mode) {
        return String.format(DOCKERFILE_TEMPLATE, mode.getName());
    }

    public static String loadDockerFileContent(LaunchMode mode) {
        String dockerFileNameInResources = DockerUtils.testUbi8Compatibility() ? String.format(DOCKERFILE_COMPATIBILITY_TEMPLATE, mode.getName()) : String.format(DOCKERFILE_TEMPLATE, mode.getName());
        return FileUtils.loadFile((String)dockerFileNameInResources);
    }

    public static String createImageAndPush(ServiceContext service, LaunchMode mode, Path artifact) {
        DockerUtils.validateContainerRegistry();
        Path target = DockerUtils.getTargetFolder(mode, artifact);
        String dockerfileContent = DockerUtils.loadDockerFileContent(mode).replaceAll(Pattern.quote("${ARTIFACT_PARENT}"), target.toString());
        Path dockerfilePath = FileUtils.copyContentTo((String)dockerfileContent, (Path)service.getServiceFolder().resolve(DOCKERFILE));
        DockerUtils.buildService(service, dockerfilePath);
        return DockerUtils.pushToContainerRegistryUrl(service);
    }

    public static boolean isVersion(Image image, String expectedVersion) {
        String[] tags;
        boolean exist = false;
        for (String tag : tags = Optional.ofNullable(image.getRepoTags()).orElse(new String[0])) {
            if (!tag.contains(expectedVersion)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static boolean removeImage(String name, String version) {
        boolean removed = false;
        Image image = DockerUtils.getImage(name, version);
        if (DockerUtils.isVersion(image, version)) {
            DockerUtils.stopContainersByImage(image.getId());
            DockerUtils.removeImageById(image.getId());
            removed = true;
        }
        return removed;
    }

    public static void removeImageById(String imageId) {
        DockerUtils.dockerClient().removeImageCmd(imageId).withForce(Boolean.valueOf(true)).exec();
    }

    public static void pullImageById(String imageId) {
        try {
            ((PullImageResultCallback)DockerUtils.dockerClient().pullImageCmd(imageId).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion((long)DOCKER_PULL_TIMEOUT_SEC.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)("Failed to pull image " + imageId + " . Caused by " + e.getMessage()));
        }
    }

    public static void stopContainersByImage(String imageId) {
        List containers = (List)DockerUtils.dockerClient().listContainersCmd().withAncestorFilter(Collections.singletonList(imageId)).exec();
        for (Container container : containers) {
            DockerUtils.dockerClient().stopContainerCmd(container.getId()).exec();
        }
    }

    public static Image getImage(String name, String version) {
        Image result = new Image();
        List images = (List)DockerUtils.dockerClient().listImagesCmd().withImageNameFilter(name).exec();
        for (Image image : images) {
            if (!DockerUtils.isVersion(image, version)) continue;
            result = image;
            break;
        }
        return result;
    }

    public static String generateDockerContainerName() {
        String containerName = "" + (RANDOM.nextInt() & Integer.MAX_VALUE);
        String dockerContainerPrefix = new PropertyLookup(Configuration.Property.CONTAINER_PREFIX.getName()).get();
        if (!Strings.isNullOrEmpty((String)dockerContainerPrefix)) {
            containerName = dockerContainerPrefix + "-" + containerName;
        }
        return containerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DockerClient dockerClient() {
        if (dockerClientInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (dockerClientInstance == null) {
                    DefaultDockerClientConfig dockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
                    ZerodepDockerHttpClient dockerHttpClient = new ZerodepDockerHttpClient.Builder().dockerHost(dockerClientConfig.getDockerHost()).sslConfig((SSLConfig)dockerClientConfig.getSSLConfig()).build();
                    dockerClientInstance = DockerClientImpl.getInstance((DockerClientConfig)dockerClientConfig, (DockerHttpClient)dockerHttpClient);
                }
            }
        }
        return dockerClientInstance;
    }

    private static void validateContainerRegistry() {
        if (StringUtils.isEmpty((CharSequence)DockerUtils.getRegistryURL())) {
            Assertions.fail((String)"Container Registry URL is not provided, use -Dts.global.container.registry-url=XXX");
        }
    }

    private static void buildService(ServiceContext service, Path dockerFile) {
        try {
            new Command(new String[]{DOCKER, "build", "-f", dockerFile.toString(), "-t", DockerUtils.getUniqueName(service), "."}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to build image " + String.valueOf(service.getServiceFolder().toAbsolutePath()) + " . Caused by " + e.getMessage()));
        }
    }

    private static String pushToContainerRegistryUrl(ServiceContext service) {
        String containerRegistryUrl = DockerUtils.getRegistryURL();
        try {
            String targetImage = containerRegistryUrl + "/" + DockerUtils.getUniqueName(service);
            new Command(new String[]{DOCKER, "tag", DockerUtils.getUniqueName(service), targetImage}).runAndWait();
            new Command(new String[]{DOCKER, "push", targetImage}).runAndWait();
            return targetImage;
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to push image " + service.getOwner().getName() + " into " + containerRegistryUrl + ". Caused by " + e.getMessage()));
            return null;
        }
    }

    private static String getRegistryURL() {
        return new PropertyLookup(Configuration.Property.CONTAINER_REGISTRY_URL.getName()).get();
    }

    private static String getUniqueName(ServiceContext service) {
        String uniqueName = service.getTestContext().getRequiredTestClass().getName() + "." + service.getName();
        return uniqueName.toLowerCase();
    }

    private static Path getTargetFolder(LaunchMode mode, Path artifact) {
        Path target = artifact.getParent();
        if (mode == LaunchMode.JVM) {
            target = target.getParent();
        }
        return target;
    }

    private static boolean testUbi8Compatibility() {
        return Boolean.getBoolean(TEST_UBI8_COMPATIBILITY);
    }
}

