/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.knative.eventing.spi;

import io.quarkus.test.services.knative.eventing.spi.ForwardResponseDTO;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;

public abstract class CompoundResponse<T> {
    private static final int TIMEOUT_SECONDS = 30;
    private final int expectedNumOfResponses;
    private final AtomicInteger actualNumOfResponses;

    protected CompoundResponse(int expectedNumOfResponses) {
        this.expectedNumOfResponses = expectedNumOfResponses;
        this.actualNumOfResponses = new AtomicInteger(0);
    }

    public final void recordVisit() {
        this.actualNumOfResponses.incrementAndGet();
    }

    public final void recordResponse(T response) {
        this.addResponse(response);
        this.actualNumOfResponses.incrementAndGet();
    }

    public final CompoundResponse<T> waitForResponses() {
        Awaitility.await().atMost(Duration.ofSeconds(30L)).until(this::isDone);
        return this;
    }

    public final ForwardResponseDTO<T> join() {
        return new ForwardResponseDTO<T>(this.getJoinedResponse());
    }

    protected abstract void addResponse(T var1);

    protected abstract T getJoinedResponse();

    private boolean isDone() {
        return this.actualNumOfResponses.get() == this.expectedNumOfResponses;
    }

    public static final class StringCompoundResponse
    extends CompoundResponse<String> {
        private final StringBuffer stringBuffer = new StringBuffer();

        public StringCompoundResponse(int expectedNumOfResponses) {
            super(expectedNumOfResponses);
        }

        @Override
        protected void addResponse(String response) {
            this.stringBuffer.append(response);
        }

        @Override
        protected String getJoinedResponse() {
            return this.stringBuffer.toString();
        }
    }
}

