/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.knative.eventing;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.eventing.v1.BrokerBuilder;
import io.fabric8.knative.eventing.v1.BrokerFluent;
import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.v1.TriggerFluent;
import io.fabric8.knative.eventing.v1.TriggerSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkus.test.bootstrap.BaseService;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.services.knative.eventing.spi.ForwardRequestDTO;
import io.quarkus.test.services.knative.eventing.spi.ForwardResponseDTO;
import io.quarkus.test.utils.AwaitilityUtils;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;

public class FunqyKnativeEventsService
extends BaseService<FunqyKnativeEventsService> {
    private static final String CLUSTER_ENTRYPOINT_PATH = "clusterEntrypoint";
    private static final String DEFAULT_BROKER_NAME = "default";
    private static final String READY = "Ready";
    private final Set<TriggerBuilder> triggerBuilders = new HashSet<TriggerBuilder>();
    private Broker broker;
    private Trigger[] triggers = null;
    private KnativeClient knativeClient;

    public FunqyKnativeEventsService() {
        this.createBrokerAndBuildTriggersOnPreStart();
        this.createTriggersOnPostStart();
    }

    private KnativeClient getKnClient() {
        if (this.knativeClient == null) {
            this.knativeClient = ((OpenShiftClient)this.context.get("openshift-client")).getKnClient();
        }
        return this.knativeClient;
    }

    private void buildTriggers(String serviceName) {
        this.triggers = (Trigger[])this.triggerBuilders.stream().map(triggerBuilder -> triggerBuilder.build(serviceName)).toArray(Trigger[]::new);
    }

    public FunqyKnativeEventsService withDefaultBroker() {
        return this.withBroker(DEFAULT_BROKER_NAME);
    }

    public FunqyKnativeEventsService withBroker(String brokerName) {
        if (this.broker != null) {
            throw new RuntimeException("Broker has already been defined. Only one broker is supported");
        }
        this.broker = ((BrokerBuilder)((BrokerFluent.MetadataNested)new BrokerBuilder().withNewMetadata().withName(brokerName)).endMetadata()).build();
        return this;
    }

    public TriggerBuilder withTrigger() {
        return new TriggerBuilder(this);
    }

    private void createBrokerAndBuildTriggersOnPreStart() {
        this.onPreStart(service -> {
            this.buildTriggers(this.getName());
            if (this.broker == null) {
                Assertions.fail((String)(FunqyKnativeEventsService.class.getName() + " - You must configure exactly one Knative broker."));
            }
            this.withProperty("broker-url", String.format("http://broker-ingress.knative-eventing.svc.cluster.local/%s/%s", this.getKnClient().getNamespace(), this.broker.getMetadata().getName()));
            this.broker = (Broker)((Resource)this.getKnClient().brokers().resource((Object)this.broker)).create();
            AtomicBoolean isBrokerReady = new AtomicBoolean(false);
            try (Watch ignored = this.watchBrokerEventsTillItsReady(this.broker.getMetadata().getName(), isBrokerReady);){
                AwaitilityUtils.untilIsTrue(isBrokerReady::get);
            }
        });
    }

    private void createTriggersOnPostStart() {
        this.onPostStart(service -> {
            if (this.triggers == null || this.triggers.length == 0) {
                Assertions.fail((String)(FunqyKnativeEventsService.class.getName() + " - You must configure at least one trigger."));
            }
            for (Trigger trigger : this.triggers) {
                ((Resource)this.getKnClient().triggers().resource((Object)trigger)).create();
                AtomicBoolean isTriggerReady = new AtomicBoolean(false);
                try (Watch ignored = this.watchTriggerEventsTillItsReady(trigger.getMetadata().getName(), isTriggerReady);){
                    AwaitilityUtils.untilIsTrue(isTriggerReady::get);
                }
            }
        });
    }

    private Watch watchBrokerEventsTillItsReady(final String brokerName, final AtomicBoolean isBrokerReady) {
        Watcher<Broker> watcher = new Watcher<Broker>(){

            public void eventReceived(Watcher.Action action, Broker broker1) {
                if (this.isOurBroker(broker1) && this.hasStatus(broker1)) {
                    isBrokerReady.set(this.isBrokerReady(broker1));
                }
            }

            private boolean isBrokerReady(Broker broker) {
                return broker.getStatus().getConditions().stream().anyMatch(condition -> FunqyKnativeEventsService.READY.equals(condition.getType()) && Boolean.parseBoolean(condition.getStatus()));
            }

            private boolean hasStatus(Broker broker) {
                return broker.getStatus() != null && broker.getStatus().getConditions() != null && !broker.getStatus().getConditions().isEmpty();
            }

            private boolean isOurBroker(Broker broker) {
                return broker != null && brokerName.equals(broker.getMetadata().getName());
            }

            public void onClose(WatcherException e) {
                Assertions.fail((String)"Broker '%s' state can't be retrieved.", (Throwable)e);
            }
        };
        return this.getKnClient().brokers().watch((Watcher)watcher);
    }

    private Watch watchTriggerEventsTillItsReady(final String triggerName, final AtomicBoolean isTriggerReady) {
        Watcher<Trigger> watcher = new Watcher<Trigger>(){

            public void eventReceived(Watcher.Action action, Trigger trigger) {
                if (this.isOurTrigger(trigger) && this.hasStatus(trigger)) {
                    isTriggerReady.set(this.isTriggerReady(trigger));
                }
            }

            private boolean isTriggerReady(Trigger trigger) {
                return trigger.getStatus().getConditions().stream().anyMatch(condition -> FunqyKnativeEventsService.READY.equals(condition.getType()) && Boolean.parseBoolean(condition.getStatus()));
            }

            private boolean hasStatus(Trigger trigger) {
                return trigger.getStatus() != null && trigger.getStatus().getConditions() != null && !trigger.getStatus().getConditions().isEmpty();
            }

            private boolean isOurTrigger(Trigger trigger) {
                return trigger != null && triggerName.equals(trigger.getMetadata().getName());
            }

            public void onClose(WatcherException e) {
                Assertions.fail((String)"Trigger '%s' state can't be retrieved.", (Throwable)e);
            }
        };
        return this.getKnClient().triggers().watch((Watcher)watcher);
    }

    public <T> FuncInvoker<T> funcInvoker() {
        return new FuncInvoker(this.getURI().getRestAssuredStyleUri());
    }

    public static final class TriggerBuilder {
        private String name = null;
        private String broker = null;
        private String filterCloudEventType = null;
        private final FunqyKnativeEventsService service;

        private TriggerBuilder(FunqyKnativeEventsService service) {
            this.service = service;
        }

        public TriggerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TriggerBuilder filterCloudEventType(String filterCloudEventType) {
            this.filterCloudEventType = filterCloudEventType;
            return this;
        }

        public TriggerBuilder defaultBroker() {
            return this.broker(FunqyKnativeEventsService.DEFAULT_BROKER_NAME);
        }

        public TriggerBuilder broker(String broker) {
            this.broker = broker;
            return this;
        }

        public FunqyKnativeEventsService endTrigger() {
            this.service.triggerBuilders.add(this);
            return this.service;
        }

        private Trigger build(String serviceName) {
            return ((io.fabric8.knative.eventing.v1.TriggerBuilder)((TriggerFluent.SpecNested)((TriggerSpecFluent.SubscriberNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((TriggerFluent.SpecNested)((TriggerSpecFluent.FilterNested)((TriggerFluent.SpecNested)((io.fabric8.knative.eventing.v1.TriggerBuilder)((TriggerFluent.MetadataNested)new io.fabric8.knative.eventing.v1.TriggerBuilder().withNewMetadata().withName(this.name.toLowerCase())).endMetadata()).withNewSpec().withBroker(this.broker)).withNewFilter().addToAttributes("type", this.filterCloudEventType)).endFilter()).withNewSubscriber().withNewRef().withApiVersion("v1")).withKind("Service")).withName(serviceName)).endRef()).endSubscriber()).endSpec()).build();
        }
    }

    public static final class FuncInvoker<T> {
        private static final String APPLICATION_CLOUD_EVENTS_PLUS_JSON = "application/cloudevents+json";
        private final RequestSpecification request;
        private String cloudEventType = null;
        private String path = "";
        private T data = null;

        private FuncInvoker(String baseUrl) {
            this.request = RestAssured.given().baseUri(Objects.requireNonNull(baseUrl));
        }

        public FuncInvoker<T> appJsonContentType() {
            this.request.contentType(ContentType.JSON);
            return this;
        }

        public FuncInvoker<T> appCloudEventsPlusJsonContentType() {
            this.requireClouedEventType();
            Objects.requireNonNull(this.data, "Please set property 'data' first.");
            this.path = "";
            this.request.contentType(APPLICATION_CLOUD_EVENTS_PLUS_JSON);
            this.request.body(new CloudEventData<T>(this.data, this.cloudEventType));
            return this;
        }

        public FuncInvoker<T> cloudEventType(String cloudEventType) {
            this.cloudEventType = cloudEventType;
            this.path = FunqyKnativeEventsService.CLUSTER_ENTRYPOINT_PATH;
            return this;
        }

        public FuncInvoker<T> data(T data) {
            this.request.body((Object)new ForwardRequestDTO(data, Objects.requireNonNull(this.cloudEventType)));
            this.data = data;
            return this;
        }

        public FuncInvoker<T> asCloudEventObject() {
            this.requireClouedEventType();
            this.path = "";
            this.request.header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-type", (Object)FunqyKnativeEventsService.CLUSTER_ENTRYPOINT_PATH, new Object[0]).header("ce-source", (Object)"test", new Object[0]);
            return this;
        }

        private void requireClouedEventType() {
            Objects.requireNonNull(this.cloudEventType, "Please set 'cloudEventType' first.");
        }

        public ForwardResponseValidator<T> post() {
            return this.validate((Response)this.request.post(this.path, new Object[0]));
        }

        public ForwardResponseValidator<T> get() {
            return this.validate((Response)this.request.get(this.path, new Object[0]));
        }

        private ForwardResponseValidator<T> validate(final Response response) {
            if (response.statusCode() == 404) {
                throw new IllegalStateException("Cluster endpoint is missing. Please expose Funqy function 'clusterEntrypoint' that forwards messages to the broker.");
            }
            return new ForwardResponseValidator<T>(){

                @Override
                public ForwardResponseValidator<T> assertBody(Matcher<T> matcher) {
                    Assertions.assertTrue((boolean)matcher.matches(((ForwardResponseDTO)response.as(ForwardResponseDTO.class)).getResponse()));
                    return this;
                }

                @Override
                public Response getResponse() {
                    return response;
                }
            };
        }

        private static final class CloudEventData<T> {
            private final ForwardRequestDTO<T> data;

            CloudEventData(T data, String cloudEventType) {
                this.data = new ForwardRequestDTO(data, cloudEventType);
            }

            public String getId() {
                return "" + UUID.randomUUID();
            }

            public String getSpecversion() {
                return "1.0";
            }

            public String getSource() {
                return "test";
            }

            public String getType() {
                return FunqyKnativeEventsService.CLUSTER_ENTRYPOINT_PATH;
            }

            public ForwardRequestDTO<T> getData() {
                return this.data;
            }

            public String getDatacontenttype() {
                return "application/json";
            }
        }
    }

    public static interface ForwardResponseValidator<T> {
        public ForwardResponseValidator<T> assertBody(Matcher<T> var1);

        public Response getResponse();
    }
}

