/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.DefaultService;
import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.scenarios.OpenShiftScenario;
import io.quarkus.test.services.Operator;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenShiftExtensionBootstrap
implements ExtensionBootstrap {
    public static final String CLIENT = "openshift-client";
    private static final PropertyLookup PRINT_INFO_ON_ERROR = new PropertyLookup("ts.openshift.print.info.on.error", Boolean.TRUE.toString());
    private static final PropertyLookup DELETE_PROJECT_AFTER = new PropertyLookup("ts.openshift.delete.project.after.all", Boolean.TRUE.toString());
    private OpenShiftClient client;

    public boolean appliesFor(ExtensionContext context) {
        return context.getRequiredTestClass().isAnnotationPresent(OpenShiftScenario.class);
    }

    public void beforeAll(ExtensionContext context) {
        this.client = OpenShiftClient.create();
        this.installOperators(context);
    }

    public void afterAll(ExtensionContext context) {
        if (DELETE_PROJECT_AFTER.getAsBoolean().booleanValue()) {
            this.client.deleteProject();
        }
    }

    public void updateServiceContext(ServiceContext context) {
        context.put(CLIENT, (Object)this.client);
    }

    public Optional<Object> getParameter(Class<?> clazz) {
        if (clazz == OpenShiftClient.class) {
            return Optional.of(this.client);
        }
        return Optional.empty();
    }

    public void onError(ExtensionContext context, Throwable throwable) {
        if (PRINT_INFO_ON_ERROR.getAsBoolean().booleanValue()) {
            FileUtils.createDirectoryIfDoesNotExist((Path)this.logsTestFolder(context));
            this.printStatus(context);
            this.printEvents(context);
            this.printPodLogs(context);
        }
    }

    private void printEvents(ExtensionContext context) {
        FileUtils.copyContentTo((String)this.client.getEvents(), (Path)this.logsTestFolder(context).resolve("events.log"));
    }

    private void printStatus(ExtensionContext context) {
        FileUtils.copyContentTo((String)this.client.getStatus(), (Path)this.logsTestFolder(context).resolve("status.log"));
    }

    private void printPodLogs(ExtensionContext context) {
        Map<String, String> logs = this.client.logs();
        for (Map.Entry<String, String> podLog : logs.entrySet()) {
            FileUtils.copyContentTo((String)podLog.getValue(), (Path)this.logsTestFolder(context).resolve(podLog.getKey() + ".log"));
        }
    }

    private Path logsTestFolder(ExtensionContext context) {
        return Log.LOG_OUTPUT_DIRECTORY.resolve(context.getRequiredTestClass().getSimpleName());
    }

    private void installOperators(ExtensionContext context) {
        OpenShiftScenario openShiftScenario = context.getRequiredTestClass().getAnnotation(OpenShiftScenario.class);
        for (Operator operator : openShiftScenario.operators()) {
            DefaultService defaultService = new DefaultService();
            defaultService.register(operator.name(), context);
            this.client.installOperator((Service)defaultService, operator.name(), operator.channel(), operator.source(), operator.sourceNamespace());
        }
    }
}

