/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap.inject;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpec;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionSpec;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.operator.model.CustomResourceStatus;
import io.quarkus.test.utils.AwaitilityUtils;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class OpenShiftClient {
    public static final String LABEL_TO_WATCH_FOR_LOGS = "tsLogWatch";
    private static final String IMAGE_STREAM_TIMEOUT = "imagestream.install.timeout";
    private static final String OPERATOR_INSTALL_TIMEOUT = "operator.install.timeout";
    private static final Duration TIMEOUT_DEFAULT = Duration.ofMinutes(5L);
    private static final String RESOURCE_PREFIX = "resource::";
    private static final String RESOURCE_MNT_FOLDER = "/resource";
    private static final int PROJECT_NAME_SIZE = 10;
    private static final int PROJECT_CREATION_RETRIES = 5;
    private static final String OPERATOR_PHASE_INSTALLED = "Succeeded";
    private static final String BUILD_FAILED_STATUS = "Failed";
    private static final String CUSTOM_RESOURCE_EXPECTED_TYPE = "Ready";
    private static final String CUSTOM_RESOURCE_EXPECTED_STATUS = "True";
    private static final String OC = "oc";
    private final String currentNamespace = this.createProject();
    private final DefaultOpenShiftClient masterClient;
    private final NamespacedOpenShiftClient client;
    private final KnativeClient kn;

    private OpenShiftClient() {
        OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).withNamespace(this.currentNamespace)).build();
        this.masterClient = new DefaultOpenShiftClient(config);
        this.client = this.masterClient.inNamespace(this.currentNamespace);
        this.kn = (KnativeClient)this.client.adapt(KnativeClient.class);
    }

    public static OpenShiftClient create() {
        return new OpenShiftClient();
    }

    public String project() {
        return this.currentNamespace;
    }

    public void apply(Path file) {
        this.applyInProject(file, this.currentNamespace);
    }

    public void applyInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "apply", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " . Caused by " + e.getMessage()));
        }
    }

    public void delete(Path file) {
        this.deleteInProject(file, this.currentNamespace);
    }

    public void deleteInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "delete", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " . Caused by " + e.getMessage()));
        }
    }

    public void applyServicePropertiesUsingTemplate(Service service, String file, UnaryOperator<String> update, Path target) {
        String content = FileUtils.loadFile((String)file);
        content = this.enrichTemplate(service, (String)update.apply(content));
        this.apply(FileUtils.copyContentTo((String)content, (Path)target));
    }

    public void applyServicePropertiesUsingDeploymentConfig(Service service) {
        DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)this.client.deploymentConfigs().withName(service.getName())).get();
        Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), dc);
        dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(envVar -> container.getEnv().add(new EnvVar((String)envVar.getKey(), (String)envVar.getValue(), null))));
        this.client.deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{dc});
    }

    public void rollout(Service service) {
        try {
            new Command(new String[]{OC, "rollout", "latest", "dc/" + service.getName(), "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Deployment failed to be started. Caused by " + e.getMessage()));
        }
    }

    public void expose(Service service, int port) {
        this.expose(service.getName(), port);
    }

    public void expose(String serviceName, int port) {
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "svc/" + serviceName, "--port=" + port, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void scaleTo(Service service, int replicas) {
        if (this.isServerlessService(service.getName())) {
            return;
        }
        try {
            new Command(new String[]{OC, "scale", "dc/" + service.getName(), "--replicas=" + replicas, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be scaled. Caused by " + e.getMessage()));
        }
    }

    public void followBuildConfigLogs(String buildConfigName) {
        AwaitilityUtils.untilIsNotNull(() -> ((BuildConfigResource)((BuildConfigResource)this.client.buildConfigs().withName(buildConfigName))).get());
        try {
            new Command(new String[]{OC, "logs", "bc/" + buildConfigName, "--follow", "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Log retrieval from bc failed. Caused by " + e.getMessage()));
        }
        if (this.isBuildFailed(buildConfigName)) {
            Assertions.fail((String)"Build failed");
        }
    }

    public boolean isBuildFailed(String buildConfigName) {
        return ((BuildList)((FilterWatchListDeletable)this.client.builds().withLabel("buildconfig", buildConfigName)).list()).getItems().stream().anyMatch(build -> BUILD_FAILED_STATUS.equals(build.getStatus().getPhase()));
    }

    public int readyReplicas(Service service) {
        DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)this.client.deploymentConfigs().withName(service.getName())).get();
        return Optional.ofNullable(dc.getStatus().getReadyReplicas()).orElse(0);
    }

    public Map<String, String> logs() {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)this.client.pods().list()).getItems()) {
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public Map<String, String> logs(Service service) {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, service.getName())).list()).getItems()) {
            if (!this.isPodRunning(pod)) continue;
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public String url(Service service) {
        return this.url(service.getName());
    }

    public String url(String serviceName) {
        if (this.isServerlessService(serviceName)) {
            Route knRoute = (Route)((Resource)this.kn.routes().withName(serviceName)).get();
            return knRoute.getStatus().getUrl();
        }
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route == null || route.getSpec() == null) {
            Assertions.fail((String)("Route for service " + serviceName + " not found"));
        }
        String protocol = route.getSpec().getTls() == null ? "http" : "https";
        String path = route.getSpec().getPath() == null ? "" : route.getSpec().getPath();
        return String.format("%s://%s%s", protocol, route.getSpec().getHost(), path);
    }

    public void awaitFor(Service service, Path file) {
        try {
            List<HasMetadata> objs = this.loadYaml(Files.readString(file));
            for (HasMetadata obj : objs) {
                if (!(obj instanceof ImageStream) || StringUtils.equals((CharSequence)obj.getMetadata().getName(), (CharSequence)service.getName())) continue;
                ImageStream is = (ImageStream)obj;
                Callable<Boolean> callable = () -> this.hasImageStreamTags(is);
                AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
                AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(IMAGE_STREAM_TIMEOUT, TIMEOUT_DEFAULT)));
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("Fail to load the file " + file + ". Caused by " + e.getMessage()));
        }
    }

    public void installOperator(Service service, String name, String channel, String source, String sourceNamespace) {
        OperatorGroup groupModel = new OperatorGroup();
        groupModel.setMetadata(new ObjectMeta());
        groupModel.getMetadata().setName(service.getName());
        groupModel.setSpec(new OperatorGroupSpec());
        groupModel.getSpec().setTargetNamespaces(Arrays.asList(this.currentNamespace));
        this.client.resource((HasMetadata)groupModel).createOrReplace();
        Subscription subscriptionModel = new Subscription();
        subscriptionModel.setMetadata(new ObjectMeta());
        subscriptionModel.getMetadata().setName(name);
        subscriptionModel.getMetadata().setNamespace(this.currentNamespace);
        subscriptionModel.setSpec(new SubscriptionSpec());
        subscriptionModel.getSpec().setChannel(channel);
        subscriptionModel.getSpec().setName(name);
        subscriptionModel.getSpec().setSource(source);
        subscriptionModel.getSpec().setSourceNamespace(sourceNamespace);
        Log.info((String)"Installing operator... %s", (Object[])new Object[]{service.getName()});
        this.client.operatorHub().subscriptions().create((Object)subscriptionModel);
        Callable<Boolean> callable = () -> {
            Subscription subscription = (Subscription)((Resource)this.client.operatorHub().subscriptions().withName(name)).get();
            String installedCsv = subscription.getStatus().getInstalledCSV();
            if (StringUtils.isEmpty((CharSequence)installedCsv)) {
                return false;
            }
            ClusterServiceVersion operatorService = (ClusterServiceVersion)((Resource)this.client.operatorHub().clusterServiceVersions().withName(installedCsv)).get();
            return OPERATOR_PHASE_INSTALLED.equals(operatorService.getStatus().getPhase());
        };
        AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
        AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(OPERATOR_INSTALL_TIMEOUT, TIMEOUT_DEFAULT)));
        Log.info((String)"Operator installed... %s", (Object[])new Object[]{service.getName()});
    }

    public boolean isCustomResourceReady(String name, Class<? extends CustomResource<?, ? extends CustomResourceStatus>> crdType) {
        CustomResource customResource = (CustomResource)((Resource)this.client.customResources(crdType).withName(name)).get();
        if (customResource == null || customResource.getStatus() == null || ((CustomResourceStatus)customResource.getStatus()).getConditions() == null) {
            return false;
        }
        return ((CustomResourceStatus)customResource.getStatus()).getConditions().stream().anyMatch(condition -> CUSTOM_RESOURCE_EXPECTED_TYPE.equals(condition.getType()) && CUSTOM_RESOURCE_EXPECTED_STATUS.equals(condition.getStatus()));
    }

    public String execOnPod(String namespace, String podName, String containerId, String ... input) throws InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        final CountDownLatch execLatch = new CountDownLatch(1);
        try (ExecWatch execWatch = (ExecWatch)((Execable)((TtyExecErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podName)).inContainer((Object)containerId)).writingOutput((Object)out)).usingListener((Object)new ExecListener(){

            public void onOpen(Response response) {
            }

            public void onFailure(Throwable throwable, Response response) {
                execLatch.countDown();
            }

            public void onClose(int i, String s) {
                execLatch.countDown();
            }
        })).exec((Object[])input);){
            execLatch.await(Duration.ZERO.toMinutes(), TimeUnit.MINUTES);
            String string = out.toString();
            return string;
        }
    }

    public boolean isServerlessService(String serviceName) {
        try {
            return ((Resource)this.kn.services().withName(serviceName)).get() != null;
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to check serverless service. Will assume it's not serverless", (Object[])new Object[]{ex});
            return false;
        }
    }

    public String getEvents() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "get", "events", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public String getStatus() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "status", "--suggest", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public void deleteProject() {
        try {
            new Command(new String[]{OC, "delete", "project", this.client.getNamespace()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
        }
        finally {
            this.masterClient.close();
        }
    }

    private String enrichTemplate(Service service, String template) {
        List<HasMetadata> objs = this.loadYaml(template);
        for (HasMetadata obj : objs) {
            obj.getMetadata().setNamespace(this.project());
            if (!(obj instanceof DeploymentConfig)) continue;
            DeploymentConfig dc = (DeploymentConfig)obj;
            dc.getMetadata().setName(service.getName());
            dc.getSpec().getTemplate().getMetadata().setNamespace(this.project());
            dc.getSpec().getTemplate().getMetadata().getLabels().put(LABEL_TO_WATCH_FOR_LOGS, service.getName());
            Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), dc);
            dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(property -> {
                String key = (String)property.getKey();
                EnvVar envVar = this.getEnvVarByKey(key, (Container)container);
                if (envVar == null) {
                    container.getEnv().add(new EnvVar(key, (String)property.getValue(), null));
                } else {
                    envVar.setValue((String)property.getValue());
                }
            }));
        }
        KubernetesList list = new KubernetesList();
        list.setItems(objs);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Serialization.yamlMapper().writeValue((OutputStream)os, (Object)list);
            template = new String(os.toByteArray());
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed adding properties into OpenShift template. Caused by " + e.getMessage()));
        }
        return template;
    }

    private EnvVar getEnvVarByKey(String key, Container container) {
        return container.getEnv().stream().filter(env -> StringUtils.equals((CharSequence)key, (CharSequence)env.getName())).findFirst().orElse(null);
    }

    private Map<String, String> enrichProperties(Map<String, String> properties, DeploymentConfig dc) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (this.isResource(entry.getValue())) {
                String path = entry.getValue().replace(RESOURCE_PREFIX, "");
                String fileName = path.substring(1);
                String configMapName = this.normalizeConfigMapName(fileName);
                this.client.configMaps().createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(fileName, FileUtils.loadFile((String)path))).build()});
                dc.getSpec().getTemplate().getSpec().getVolumes().add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(configMapName)).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(configMapName)).build())).build());
                dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(configMapName)).withReadOnly(Boolean.valueOf(true))).withMountPath(RESOURCE_MNT_FOLDER)).build()));
                value = RESOURCE_MNT_FOLDER + path;
            }
            output.put(entry.getKey(), (String)value);
        }
        return output;
    }

    private String normalizeConfigMapName(String name) {
        return name.replaceAll(Pattern.quote("."), "-");
    }

    private boolean isResource(String key) {
        return key.startsWith(RESOURCE_PREFIX);
    }

    private boolean hasImageStreamTags(ImageStream is) {
        return !((ImageStream)((Resource)this.masterClient.imageStreams().withName(is.getMetadata().getName())).get()).getStatus().getTags().isEmpty();
    }

    private boolean isPodRunning(Pod pod) {
        return pod.getStatus().getPhase().equals("Running");
    }

    private String createProject() {
        boolean projectCreated = false;
        String namespace = this.generateRandomProjectName();
        for (int index = 0; index < 5; ++index) {
            if (this.doCreateProject(namespace)) {
                projectCreated = true;
                break;
            }
            namespace = this.generateRandomProjectName();
        }
        if (!projectCreated) {
            Assertions.fail((String)"Project cannot be created. Review your OpenShift installation.");
        }
        return namespace;
    }

    private boolean doCreateProject(String projectName) {
        boolean created = false;
        try {
            new Command(new String[]{OC, "new-project", projectName}).runAndWait();
            created = true;
        }
        catch (Exception e) {
            Log.warn((String)("Project " + projectName + " failed to be created. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return created;
    }

    private List<HasMetadata> loadYaml(String template) {
        return (List)this.client.load((InputStream)new ByteArrayInputStream(template.getBytes())).get();
    }

    private String generateRandomProjectName() {
        return ThreadLocalRandom.current().ints(10L, 97, 123).collect(() -> new StringBuilder("ts-"), StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

