/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.utils.Command;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class BuildOpenShiftQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<ProdQuarkusApplicationManagedResourceBuilder> {
    private static final String S2I_DEFAULT_VERSION = "latest";
    private static final String QUARKUS_OPENSHIFT_TEMPLATE = "/quarkus-build-openshift-template.yml";
    private static final String IMAGE_TAG_SEPARATOR = ":";
    private static final PropertyLookup UBI_QUARKUS_JVM_S2I = new PropertyLookup("quarkus.s2i.base-jvm-image", "registry.access.redhat.com/ubi8/openjdk-11:latest");
    private static final PropertyLookup UBI_QUARKUS_NATIVE_S2I = new PropertyLookup("quarkus.s2i.base-native-image", "quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0");

    public BuildOpenShiftQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_OPENSHIFT_TEMPLATE;
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.startBuild();
        this.exposeServices();
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String s2iImage = this.getS2iImage();
        String s2iVersion = this.getS2iImageVersion(s2iImage);
        return content.replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER}"), StringUtils.substringBeforeLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR)).replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER_VERSION}"), s2iVersion).replaceAll(Pattern.quote("${ARTIFACT}"), ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().getFileName().toString());
    }

    private void exposeServices() {
        this.client.expose(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner(), 8080);
    }

    private void startBuild() {
        String fromArg = "--from-dir=" + ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath().getParent().toString();
        if (this.isNativeTest()) {
            fromArg = "--from-file=" + ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath().toString();
        }
        try {
            new Command(new String[]{"oc", "start-build", ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName(), fromArg, "--follow"}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed when starting build. Caused by " + e.getMessage()));
        }
    }

    private String getS2iImageVersion(String s2iImage) {
        String s2iVersion = S2I_DEFAULT_VERSION;
        if (s2iImage.contains(IMAGE_TAG_SEPARATOR)) {
            s2iVersion = StringUtils.substringAfterLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR);
        }
        return s2iVersion;
    }

    private String getS2iImage() {
        PropertyLookup s2iImageProperty = UBI_QUARKUS_JVM_S2I;
        if (this.isNativeTest()) {
            s2iImageProperty = UBI_QUARKUS_NATIVE_S2I;
        }
        return s2iImageProperty.get(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext());
    }
}

