/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.quarkus.OpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.MavenUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;

public class ExtensionOpenShiftQuarkusApplicationManagedResource
extends OpenShiftQuarkusApplicationManagedResource<ProdQuarkusApplicationManagedResourceBuilder> {
    private static final String USING_EXTENSION_PROFILE = "-Pdeploy-to-openshift-using-extension";
    private static final String QUARKUS_PLUGIN_DEPLOY = "-Dquarkus.kubernetes.deploy=true";
    private static final String QUARKUS_PLUGIN_EXPOSE = "-Dquarkus.openshift.expose=true";
    private static final String QUARKUS_CONTAINER_NAME = "quarkus.application.name";
    private static final String QUARKUS_KUBERNETES_CLIENT_NAMESPACE = "quarkus.kubernetes-client.namespace";
    private static final String QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS = "quarkus.kubernetes-client.trust-certs";
    private static final String QUARKUS_CONTAINER_IMAGE_GROUP = "quarkus.container-image.group";
    private static final String QUARKUS_OPENSHIFT_ENV_VARS = "quarkus.openshift.env.vars.";
    private static final String QUARKUS_OPENSHIFT_LABELS = "quarkus.openshift.labels.";
    private static final String APPLICATION_PROPERTIES_PATH = "src/main/resources/application.properties";

    public ExtensionOpenShiftQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected void doInit() {
        this.cloneProjectToServiceAppFolder();
        this.copyBuildPropertiesIntoAppFolder();
        this.deployProjectUsingMavenCommand();
    }

    @Override
    protected void doUpdate() {
        this.client.applyServicePropertiesUsingDeploymentConfig(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner());
    }

    public boolean needsBuildArtifact() {
        return false;
    }

    public void validate() {
        super.validate();
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).isSelectedAppClasses()) {
            Assertions.fail((String)"Custom source classes as @QuarkusApplication(classes = ...) is not supported by `UsingOpenShiftExtension`");
        }
    }

    protected void withAdditionalArguments(List<String> args) {
    }

    private void copyBuildPropertiesIntoAppFolder() {
        Map buildProperties = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getBuildProperties();
        if (buildProperties.isEmpty()) {
            return;
        }
        Path applicationPropertiesPath = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder().resolve(APPLICATION_PROPERTIES_PATH);
        if (Files.exists(applicationPropertiesPath, new LinkOption[0])) {
            buildProperties.putAll(PropertiesUtils.toMap((Path)applicationPropertiesPath));
        }
        PropertiesUtils.fromMap((Map)buildProperties, (Path)applicationPropertiesPath);
        ((ProdQuarkusApplicationManagedResourceBuilder)this.model).createSnapshotOfBuildProperties();
    }

    private void deployProjectUsingMavenCommand() {
        MavenUtils.installParentPomsIfNeeded();
        String namespace = this.client.project();
        List args = MavenUtils.mvnCommand((ServiceContext)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext());
        args.addAll(Arrays.asList(USING_EXTENSION_PROFILE, "-B", "-V", "package", QUARKUS_PLUGIN_DEPLOY, QUARKUS_PLUGIN_EXPOSE, "-DskipTests=true", "-DskipITs=true", "-Dcheckstyle.skip"));
        args.add(this.withContainerName());
        args.add(this.withKubernetesClientNamespace(namespace));
        args.add(this.withKubernetesClientTrustCerts());
        args.add(this.withContainerImageGroup(namespace));
        args.add(this.withLabelsForWatching());
        this.withEnvVars(args, ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperties());
        this.withAdditionalArguments(args);
        try {
            new Command(args).onDirectory(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to run maven command. Caused by " + e.getMessage()));
        }
    }

    private String withLabelsForWatching() {
        return MavenUtils.withProperty((String)"quarkus.openshift.labels.tsLogWatch", (String)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName());
    }

    private String withContainerName() {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_NAME, (String)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName());
    }

    private String withContainerImageGroup(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_IMAGE_GROUP, (String)namespace);
    }

    private String withKubernetesClientNamespace(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_NAMESPACE, (String)namespace);
    }

    private String withKubernetesClientTrustCerts() {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS, (String)Boolean.TRUE.toString());
    }

    private void withEnvVars(List<String> args, Map<String, String> envVars) {
        for (Map.Entry<String, String> envVar : envVars.entrySet()) {
            String envVarKey = envVar.getKey().replaceAll(Pattern.quote("."), "-");
            args.add(MavenUtils.withProperty((String)(QUARKUS_OPENSHIFT_ENV_VARS + envVarKey), (String)envVar.getValue()));
        }
    }

    private void cloneProjectToServiceAppFolder() {
        FileUtils.copyCurrentDirectoryTo((Path)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder());
    }
}

