/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.services.quarkus.ExtensionOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.DockerUtils;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.MavenUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;

public class ExtensionOpenShiftUsingDockerBuildStrategyQuarkusApplicationManagedResource
extends ExtensionOpenShiftQuarkusApplicationManagedResource {
    private static final String QUARKUS_OPENSHIFT_BUILD_STRATEGY = "quarkus.openshift.build-strategy";
    private static final String DOCKER = "docker";
    private static final String DOCKERFILE_SOURCE_FOLDER = "src/main/docker";

    public ExtensionOpenShiftUsingDockerBuildStrategyQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected void withAdditionalArguments(List<String> args) {
        this.copyDockerfileToSources();
        args.add(MavenUtils.withProperty((String)QUARKUS_OPENSHIFT_BUILD_STRATEGY, (String)DOCKER));
    }

    private void copyDockerfileToSources() {
        Path dockerfileTarget = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder().resolve(DOCKERFILE_SOURCE_FOLDER);
        if (!Files.exists(dockerfileTarget, new LinkOption[0])) {
            FileUtils.createDirectory((Path)dockerfileTarget);
        }
        String dockerfileName = DockerUtils.getDockerfile((LaunchMode)this.getLaunchMode());
        if (!Files.exists(dockerfileTarget.resolve(dockerfileTarget), new LinkOption[0])) {
            String dockerFileContent = FileUtils.loadFile((String)DockerUtils.getDockerfile((LaunchMode)this.getLaunchMode())).replaceAll(Pattern.quote("${ARTIFACT_PARENT}"), "target");
            FileUtils.copyContentTo((String)dockerFileContent, (Path)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder().resolve(DOCKERFILE_SOURCE_FOLDER + dockerfileName));
        }
    }
}

