/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public abstract class OpenShiftQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends QuarkusManagedResource {
    private static final int EXTERNAL_PORT = 80;
    protected final T model;
    protected final OpenShiftClient client;
    private LoggingHandler loggingHandler;
    private boolean init;
    private boolean running;

    public OpenShiftQuarkusApplicationManagedResource(T model) {
        super(model.getContext());
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    protected abstract void doInit();

    protected abstract void doUpdate();

    public void start() {
        if (this.running) {
            return;
        }
        if (!this.init) {
            this.doInit();
            this.init = true;
        } else {
            this.doUpdate();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public String getHost(Protocol protocol) {
        this.validateProtocol(protocol);
        return this.client.url(this.model.getContext().getOwner());
    }

    public int getPort(Protocol protocol) {
        this.validateProtocol(protocol);
        return 80;
    }

    public boolean isRunning() {
        if (!this.running) {
            return false;
        }
        if (this.client.isServerlessService(this.model.getContext().getName())) {
            return this.routeIsReachable(Protocol.HTTP);
        }
        return super.isRunning() && this.routeIsReachable(Protocol.HTTP);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        if (this.model.containsBuildProperties()) {
            this.init = false;
            this.model.build();
        }
        this.start();
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private void validateProtocol(Protocol protocol) {
        if (protocol == Protocol.HTTPS) {
            Assertions.fail((String)"SSL is not supported for OpenShift tests yet");
        } else if (protocol == Protocol.GRPC) {
            Assertions.fail((String)"gRPC is not supported for OpenShift tests yet");
        }
    }

    private boolean routeIsReachable(Protocol protocol) {
        return ((Response)RestAssured.given().baseUri(this.getHost(protocol)).basePath("/").port(this.getPort(protocol)).get()).getStatusCode() != 503;
    }
}

