/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.builder.Version;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.services.quarkus.GitRepositoryQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<GitRepositoryQuarkusApplicationManagedResourceBuilder> {
    private static final String QUARKUS_SOURCE_S2I_BASE_IMAGE_FILENAME = "openjdk-11.yml";
    private static final String QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME = "/quarkus-s2i-source-build-template.yml";
    private static final String QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME = "settings-mvn.yml";
    private static final String QUARKUS_VERSION_PROPERTY = "${QUARKUS_VERSION}";
    private static final String INTERNAL_MAVEN_REPOSITORY_PROPERTY = "${internal.s2i.maven.remote.repository}";
    private static final String QUARKUS_SNAPSHOT_VERSION = "999-SNAPSHOT";
    private static final PropertyLookup MAVEN_REMOTE_REPOSITORY = new PropertyLookup("s2i.maven.remote.repository");
    private final GitRepositoryQuarkusApplicationManagedResourceBuilder model;

    public OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource(GitRepositoryQuarkusApplicationManagedResourceBuilder model) {
        super(model);
        this.model = model;
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME;
    }

    @Override
    protected void doInit() {
        this.waitForBaseImage();
        this.createMavenSettings();
        super.doInit();
        this.client.followBuildConfigLogs(this.model.getContext().getName());
    }

    protected boolean needsBuildArtifact() {
        return false;
    }

    protected void validate() {
        super.validate();
        if (QUARKUS_SNAPSHOT_VERSION.equals(Version.getVersion()) && StringUtils.isEmpty((CharSequence)MAVEN_REMOTE_REPOSITORY.get(this.model.getContext()))) {
            Assertions.fail((String)"s2i can't use the Quarkus 999-SNAPSHOT version if not Maven repository has been provided");
        }
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String quarkusVersion = Version.getVersion();
        String mavenArgs = this.model.getMavenArgs().replaceAll(Pattern.quote(QUARKUS_VERSION_PROPERTY), quarkusVersion);
        return content.replaceAll(Pattern.quote("${APP_NAME}"), this.model.getContext().getOwner().getName()).replaceAll(Pattern.quote("${GIT_URI}"), this.model.getGitRepository()).replaceAll(Pattern.quote("${GIT_REF}"), this.model.getGitBranch()).replaceAll(Pattern.quote("${CONTEXT_DIR}"), this.model.getContextDir()).replaceAll(Pattern.quote("${GIT_MAVEN_ARGS}"), mavenArgs).replaceAll(Pattern.quote(QUARKUS_VERSION_PROPERTY), quarkusVersion);
    }

    private void waitForBaseImage() {
        Path targetQuarkusSourceS2iBaseImageFileName = this.model.getContext().getServiceFolder().resolve(QUARKUS_SOURCE_S2I_BASE_IMAGE_FILENAME);
        FileUtils.copyFileTo((String)QUARKUS_SOURCE_S2I_BASE_IMAGE_FILENAME, (Path)targetQuarkusSourceS2iBaseImageFileName);
        this.client.apply(targetQuarkusSourceS2iBaseImageFileName);
        this.client.awaitFor(this.model.getContext().getOwner(), targetQuarkusSourceS2iBaseImageFileName);
    }

    private void createMavenSettings() {
        Path targetQuarkusSourceS2iSettingsMvnFilename = this.model.getContext().getServiceFolder().resolve(QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME);
        String content = FileUtils.loadFile((String)"/settings-mvn.yml");
        String remoteRepo = MAVEN_REMOTE_REPOSITORY.get(this.model.getContext());
        if (StringUtils.isNotEmpty((CharSequence)remoteRepo)) {
            content = content.replaceAll(Pattern.quote(INTERNAL_MAVEN_REPOSITORY_PROPERTY), remoteRepo);
        }
        FileUtils.copyContentTo((String)content, (Path)targetQuarkusSourceS2iSettingsMvnFilename);
        this.client.apply(targetQuarkusSourceS2iSettingsMvnFilename);
    }
}

