/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.quarkus.OpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class TemplateOpenShiftQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends OpenShiftQuarkusApplicationManagedResource<T> {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "openshift.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "openshift.template";
    private static final String DEPLOYMENT = "openshift.yml";
    private static final String QUARKUS_HTTP_PORT_PROPERTY = "quarkus.http.port";
    private static final int INTERNAL_PORT_DEFAULT = 8080;

    public TemplateOpenShiftQuarkusApplicationManagedResource(T model) {
        super(model);
    }

    protected abstract String getDefaultTemplate();

    protected String replaceDeploymentContent(String content) {
        return content;
    }

    @Override
    protected void doInit() {
        this.applyTemplate();
        this.awaitForImageStreams();
    }

    @Override
    protected void doUpdate() {
        this.applyTemplate();
    }

    protected int getInternalPort() {
        String internalPort = (String)this.model.getContext().getOwner().getProperties().get(QUARKUS_HTTP_PORT_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)internalPort)) {
            return Integer.parseInt(internalPort);
        }
        return 8080;
    }

    private void applyTemplate() {
        String deploymentFile = this.model.getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, this.getDefaultTemplate());
        this.client.applyServicePropertiesUsingTemplate(this.model.getContext().getOwner(), deploymentFile, this::internalReplaceDeploymentContent, this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private String internalReplaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getOwner().getName());
        }
        content = content.replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), "" + this.getInternalPort());
        return this.replaceDeploymentContent(content);
    }

    private void awaitForImageStreams() {
        Log.info((Service)this.model.getContext().getOwner(), (String)"Waiting for image streams ... ", (Object[])new Object[0]);
        this.client.awaitFor(this.model.getContext().getOwner(), this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }
}

