/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap.inject;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpec;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionSpec;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.impl.OpenShiftClientImpl;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.model.CustomVolume;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.operator.model.CustomResourceStatus;
import io.quarkus.test.utils.AwaitilityUtils;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public final class OpenShiftClient {
    public static final String LABEL_TO_WATCH_FOR_LOGS = "tsLogWatch";
    public static final String LABEL_SCENARIO_ID = "scenarioId";
    public static final PropertyLookup ENABLED_EPHEMERAL_NAMESPACES = new PropertyLookup("ts.openshift.ephemeral.namespaces.enabled", Boolean.TRUE.toString());
    private static final Logger LOG = Logger.getLogger(OpenShiftClient.class);
    private static final String IMAGE_STREAM_TIMEOUT = "imagestream.install.timeout";
    private static final String OPERATOR_INSTALL_TIMEOUT = "operator.install.timeout";
    private static final Duration TIMEOUT_DEFAULT = Duration.ofMinutes(5L);
    private static final int PROJECT_NAME_SIZE = 10;
    private static final int PROJECT_CREATION_RETRIES = 5;
    private static final String OPERATOR_PHASE_INSTALLED = "Succeeded";
    private static final String BUILD_FAILED_STATUS = "Failed";
    private static final String CUSTOM_RESOURCE_EXPECTED_TYPE = "Ready";
    private static final String CUSTOM_RESOURCE_EXPECTED_STATUS = "True";
    private static final String RESOURCE_MNT_FOLDER = "/resources";
    private static final String OC = "oc";
    private final String currentNamespace;
    private final OpenShiftClientImpl client;
    private final KnativeClient kn;
    private final String scenarioId;
    private boolean isClientReady;

    private OpenShiftClient(String scenarioId) {
        this.scenarioId = scenarioId;
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            this.currentNamespace = this.createProject();
            OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).withNamespace(this.currentNamespace)).build();
            this.client = OpenShiftClient.createClient(config);
        } else {
            OpenShiftConfig config = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).build();
            this.client = OpenShiftClient.createClient(config);
            this.currentNamespace = this.client.getNamespace();
        }
        this.isClientReady = true;
        this.kn = (KnativeClient)this.client.adapt(KnativeClient.class);
    }

    private static OpenShiftClientImpl createClient(OpenShiftConfig config) {
        return (OpenShiftClientImpl)((NamespacedOpenShiftClient)new KubernetesClientBuilder().withConfig((Config)config).build().adapt(NamespacedOpenShiftClient.class)).adapt(OpenShiftClientImpl.class);
    }

    public static OpenShiftClient create(String scenarioId) {
        return new OpenShiftClient(scenarioId);
    }

    public String project() {
        return this.currentNamespace;
    }

    public void apply(Path file) {
        this.applyInProject(file, this.currentNamespace);
    }

    public void applyInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "apply", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " . Caused by " + e.getMessage()));
        }
    }

    public void delete(Path file) {
        this.deleteInProject(file, this.currentNamespace);
    }

    public void deleteInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "delete", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " . Caused by " + e.getMessage()));
        }
    }

    public void applyServicePropertiesUsingTemplate(Service service, String file, UnaryOperator<String> update, Path target) {
        this.applyServicePropertiesUsingTemplate(service, file, update, Collections.emptyMap(), target);
    }

    public void applyServicePropertiesUsingTemplate(Service service, String file, UnaryOperator<String> update, Map<String, String> extraTemplateProperties, Path target) {
        Log.info((String)"Enriching template %s to create a deployment file %s ", (Object[])new Object[]{file, target});
        String content = FileUtils.loadFile((String)file);
        content = this.enrichTemplate(service, (String)update.apply(content), extraTemplateProperties);
        this.apply(FileUtils.copyContentTo((String)content, (Path)target));
    }

    public void applyServicePropertiesUsingDeploymentConfig(Service service) {
        DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)this.client.deploymentConfigs().withName(service.getName())).get();
        Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), dc);
        dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(envVar -> container.getEnv().add(new EnvVar((String)envVar.getKey(), (String)envVar.getValue(), null))));
        ((DeployableScalableResource)this.client.deploymentConfigs().resource((Object)dc)).createOrReplace();
    }

    public void rollout(Service service) {
        try {
            new Command(new String[]{OC, "rollout", "latest", "dc/" + service.getName(), "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Deployment failed to be started. Caused by " + e.getMessage()));
        }
    }

    public void expose(Service service, int port) {
        this.expose(service.getName(), port);
    }

    public void expose(String serviceName, int port) {
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "svc/" + serviceName, "--port=" + port, "-n", this.currentNamespace, "-lscenarioId=" + this.getScenarioId()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void expose(String serviceName, String routeName, int port) {
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(routeName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "svc/" + serviceName, "--port=" + port, "--name=" + routeName, "-n", this.currentNamespace, "-lscenarioId=" + this.getScenarioId()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void scaleTo(Service service, int replicas) {
        if (this.isServerlessService(service.getName())) {
            return;
        }
        try {
            new Command(new String[]{OC, "scale", "dc/" + service.getName(), "--replicas=" + replicas, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be scaled. Caused by " + e.getMessage()));
        }
    }

    public void scaleToWhenDcReady(Service service, int replicas) {
        if (this.isServerlessService(service.getName())) {
            return;
        }
        AwaitilityUtils.untilIsTrue(() -> {
            Log.info((String)"Waiting for dc to be ready", (Object[])new Object[0]);
            return ((DeployableScalableResource)this.client.deploymentConfigs().withName(service.getName())).get() != null;
        });
        this.scaleTo(service, replicas);
    }

    public void followBuildConfigLogs(String buildConfigName) {
        AwaitilityUtils.untilIsNotNull(() -> ((BuildConfigResource)((BuildConfigResource)this.client.buildConfigs().withName(buildConfigName))).get());
        try {
            new Command(new String[]{OC, "logs", "bc/" + buildConfigName, "--follow", "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Log retrieval from bc failed. Caused by " + e.getMessage()));
        }
        if (this.isBuildFailed(buildConfigName)) {
            Assertions.fail((String)"Build failed");
        }
    }

    public boolean isBuildFailed(String buildConfigName) {
        return ((BuildList)((FilterWatchListDeletable)this.client.builds().withLabel("buildconfig", buildConfigName)).list()).getItems().stream().anyMatch(build -> BUILD_FAILED_STATUS.equals(build.getStatus().getPhase()));
    }

    public int readyReplicas(Service service) {
        DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)this.client.deploymentConfigs().withName(service.getName())).get();
        return Optional.ofNullable(dc.getStatus().getReadyReplicas()).orElse(0);
    }

    public List<Pod> podsInService(Service service) {
        return ((PodList)((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, service.getName())).list()).getItems();
    }

    public Map<String, String> logs() {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)this.client.pods().list()).getItems()) {
            String podName = pod.getMetadata().getName();
            PodResource resource = (PodResource)this.client.pods().withName(podName);
            for (Container container : pod.getSpec().getContainers()) {
                logs.put(podName + "-" + container.getName(), ((ContainerResource)resource.inContainer((Object)container.getName())).getLog());
            }
        }
        return logs;
    }

    public Map<String, String> logs(Service service) {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : this.podsInService(service)) {
            if (!this.isPodRunning(pod)) continue;
            String podName = pod.getMetadata().getName();
            PodResource resource = (PodResource)this.client.pods().withName(podName);
            for (Container container : pod.getSpec().getContainers()) {
                logs.put(podName + "-" + container.getName(), ((ContainerResource)resource.inContainer((Object)container.getName())).getLog());
            }
        }
        return logs;
    }

    public URILike url(Service service) {
        return this.url(service.getName());
    }

    public URILike url(String serviceName) {
        if (this.isServerlessService(serviceName)) {
            Route knRoute = (Route)((Resource)this.kn.routes().withName(serviceName)).get();
            return URILike.parse((String)knRoute.getStatus().getUrl());
        }
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route == null || route.getSpec() == null) {
            Assertions.fail((String)("Route for service " + serviceName + " not found"));
        }
        String protocol = route.getSpec().getTls() == null ? "http" : "https";
        String path = route.getSpec().getPath() == null ? "" : route.getSpec().getPath();
        return new URILike(protocol, route.getSpec().getHost(), -1, path);
    }

    public void awaitFor(Service service, Path file) {
        try {
            List<HasMetadata> objs = this.loadYaml(Files.readString(file));
            for (HasMetadata obj : objs) {
                if (!(obj instanceof ImageStream) || StringUtils.equals((CharSequence)obj.getMetadata().getName(), (CharSequence)service.getName())) continue;
                ImageStream is = (ImageStream)obj;
                Callable<Boolean> callable = () -> this.hasImageStreamTags(is);
                AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
                AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(IMAGE_STREAM_TIMEOUT, TIMEOUT_DEFAULT)));
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("Fail to load the file " + file + ". Caused by " + e.getMessage()));
        }
    }

    public void installOperator(Service service, String name, String channel, String source, String sourceNamespace) {
        if (!ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            throw new UnsupportedOperationException("Operators not supported with ephemeral namespaces disabled");
        }
        OperatorGroup groupModel = new OperatorGroup();
        groupModel.setMetadata(new ObjectMeta());
        groupModel.getMetadata().setName(service.getName());
        groupModel.setSpec(new OperatorGroupSpec());
        groupModel.getSpec().setTargetNamespaces(Arrays.asList(this.currentNamespace));
        this.client.resource((HasMetadata)groupModel).createOrReplace();
        Subscription subscriptionModel = new Subscription();
        subscriptionModel.setMetadata(new ObjectMeta());
        subscriptionModel.getMetadata().setName(name);
        subscriptionModel.getMetadata().setNamespace(this.currentNamespace);
        subscriptionModel.setSpec(new SubscriptionSpec());
        subscriptionModel.getSpec().setChannel(channel);
        subscriptionModel.getSpec().setName(name);
        subscriptionModel.getSpec().setSource(source);
        subscriptionModel.getSpec().setSourceNamespace(sourceNamespace);
        Log.info((String)"Installing operator... %s", (Object[])new Object[]{service.getName()});
        ((Resource)this.client.operatorHub().subscriptions().resource((Object)subscriptionModel)).create();
        Callable<Boolean> callable = () -> {
            Subscription subscription = (Subscription)((Resource)this.client.operatorHub().subscriptions().withName(name)).get();
            String installedCsv = subscription.getStatus().getInstalledCSV();
            if (StringUtils.isEmpty((CharSequence)installedCsv)) {
                return false;
            }
            ClusterServiceVersion operatorService = (ClusterServiceVersion)((Resource)this.client.operatorHub().clusterServiceVersions().withName(installedCsv)).get();
            return OPERATOR_PHASE_INSTALLED.equals(operatorService.getStatus().getPhase());
        };
        AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
        AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(OPERATOR_INSTALL_TIMEOUT, TIMEOUT_DEFAULT)));
        Log.info((String)"Operator installed... %s", (Object[])new Object[]{service.getName()});
    }

    public boolean isCustomResourceReady(String name, Class<? extends CustomResource<?, ? extends CustomResourceStatus>> crdType) {
        if (!this.isClientReady) {
            return false;
        }
        CustomResource customResource = (CustomResource)((Resource)this.client.resources(crdType).withName(name)).get();
        if (customResource == null || customResource.getStatus() == null || ((CustomResourceStatus)customResource.getStatus()).getConditions() == null) {
            return false;
        }
        return ((CustomResourceStatus)customResource.getStatus()).getConditions().stream().anyMatch(condition -> CUSTOM_RESOURCE_EXPECTED_TYPE.equals(condition.getType()) && CUSTOM_RESOURCE_EXPECTED_STATUS.equals(condition.getStatus()));
    }

    public String execOnPod(String namespace, String podName, String containerId, String ... input) throws InterruptedException, IOException {
        ArrayList output = new ArrayList();
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(OC, "exec", podName, "-c", containerId, "-n", namespace));
        List<String> command = Arrays.asList(input);
        if (!command.isEmpty()) {
            args.add("--");
            args.addAll(command);
        }
        new Command(args).outputToLines(output).runAndWait();
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public boolean isServerlessService(String serviceName) {
        try {
            return ((Resource)this.kn.services().withName(serviceName)).get() != null;
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to check serverless service. Will assume it's not serverless", (Object[])new Object[]{ex});
            return false;
        }
    }

    public String getEvents() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "get", "events", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public String getStatus() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "status", "--suggest", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject() {
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            try {
                List finalizers;
                Resource projectResource = (Resource)this.client.projects().withName(this.currentNamespace);
                Project project = (Project)projectResource.get();
                if (project == null) {
                    LOG.infof("Skipping delete operation on project '%s' as project does not exists", (Object)this.currentNamespace);
                    return;
                }
                if (project.isMarkedForDeletion()) {
                    LOG.infof("Skipping delete operation on project '%s' as project is already marked for deletion", (Object)this.currentNamespace);
                    return;
                }
                LOG.infof("Deleting project '%s'", (Object)this.currentNamespace);
                if (projectResource.delete().stream().allMatch(Objects::isNull)) {
                    LOG.infof("Project '%s' deleted", (Object)this.currentNamespace);
                    return;
                }
                project = (Project)projectResource.update();
                if (project == null) {
                    LOG.warnf("Deleted project '%s', but behavior of 'io.fabric8.kubernetes.client.dsl.Deletable.delete' has changed, we need to refactor this operation", (Object)this.currentNamespace);
                    return;
                }
                if (!project.isMarkedForDeletion()) {
                    Assertions.fail((String)("Illegal state - project '" + this.currentNamespace + "' should be marked for deletion, please delete project manually"));
                }
                if ((finalizers = project.getFinalizers()) != null && !finalizers.isEmpty()) {
                    LOG.infof("Attempting to delete finalizers '%s' of project '%s' as the project wasn't cleaned up within default timeout", (Object)Arrays.toString(finalizers.toArray()), (Object)this.currentNamespace);
                    finalizers.forEach(arg_0 -> ((Project)project).removeFinalizer(arg_0));
                    projectResource.patch((Object)project);
                    AwaitilityUtils.until(() -> ((Resource)projectResource).get(), (Matcher)Matchers.nullValue());
                }
                Assertions.fail((String)"Failed to delete project within default timeout, project is marked for deletion, but we might need too raise waiting period");
            }
            catch (AssertionFailedError e) {
                Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.errorf("Failed to delete project %s", (Object)this.currentNamespace, (Object)e);
                Assertions.fail((String)"Failed to delete OpenShit project");
            }
            finally {
                this.client.close();
                this.isClientReady = false;
            }
        } else {
            this.deleteResourcesByLabel(LABEL_SCENARIO_ID, this.getScenarioId());
        }
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public KnativeClient getKnClient() {
        return this.kn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResourcesByLabel(String labelName, String labelValue) {
        try {
            String label = String.format("%s=%s", labelName, labelValue);
            new Command(new String[]{OC, "delete", "-n", this.currentNamespace, "all", "-l", label}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
        }
        finally {
            this.client.close();
            this.isClientReady = false;
        }
    }

    private String enrichTemplate(Service service, String template, Map<String, String> extraTemplateProperties) {
        List<HasMetadata> objs = this.loadYaml(template);
        for (HasMetadata obj : objs) {
            obj.getMetadata().setNamespace(this.project());
            Map objMetadataLabels = Optional.ofNullable(obj.getMetadata().getLabels()).orElse(new HashMap());
            objMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            obj.getMetadata().setLabels(objMetadataLabels);
            if (!(obj instanceof DeploymentConfig)) continue;
            DeploymentConfig dc = (DeploymentConfig)obj;
            dc.getMetadata().setName(service.getName());
            dc.getSpec().getTemplate().getMetadata().setNamespace(this.project());
            Map templateMetadataLabels = dc.getSpec().getTemplate().getMetadata().getLabels();
            templateMetadataLabels.put(LABEL_TO_WATCH_FOR_LOGS, service.getName());
            templateMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), dc);
            enrichProperties.putAll(extraTemplateProperties);
            dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(property -> {
                String key = (String)property.getKey();
                EnvVar envVar = this.getEnvVarByKey(key, (Container)container);
                if (envVar == null) {
                    container.getEnv().add(new EnvVar(key, (String)property.getValue(), null));
                } else {
                    envVar.setValue((String)property.getValue());
                }
            }));
        }
        KubernetesList list = new KubernetesList();
        list.setItems(objs);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Serialization.yamlMapper().writeValue((OutputStream)os, (Object)list);
            template = new String(os.toByteArray());
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed adding properties into OpenShift template. Caused by " + e.getMessage()));
        }
        return template;
    }

    private EnvVar getEnvVarByKey(String key, Container container) {
        return container.getEnv().stream().filter(env -> StringUtils.equals((CharSequence)key, (CharSequence)env.getName())).findFirst().orElse(null);
    }

    private Map<String, String> enrichProperties(Map<String, String> properties, DeploymentConfig dc) {
        HashMap<Object, CustomVolume> volumes = new HashMap<Object, CustomVolume>();
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String filename;
            String mountPath;
            String path;
            Object propertyValue = entry.getValue();
            if (this.isResource((String)propertyValue)) {
                path = entry.getValue().replace("resource::/", "");
                mountPath = this.getMountPath(path);
                filename = this.getFileName(path);
                String configMapName = this.normalizeConfigMapName(mountPath);
                this.createOrUpdateConfigMap(configMapName, filename, this.getFileContent(path));
                if (!volumes.containsKey(mountPath)) {
                    volumes.put(mountPath, new CustomVolume(configMapName, "", CustomVolume.VolumeType.CONFIG_MAP));
                }
                propertyValue = mountPath + PropertiesUtils.SLASH + filename;
            } else if (this.isResourceWithDestinationPath((String)propertyValue)) {
                path = ((String)propertyValue).replace("resource_with_destination::", "");
                if (!((String)propertyValue).matches(".*\\|.*")) {
                    String errorMsg = String.format("Unexpected %s format. Expected destinationPath|fileName but found %s", "resource_with_destination::", propertyValue);
                    throw new RuntimeException(errorMsg);
                }
                mountPath = path.split("\\|")[0];
                String fileName = path.split("\\|")[1];
                String fileNameNormalized = this.getFileName(fileName);
                String configMapName = this.normalizeConfigMapName(mountPath);
                this.createOrUpdateConfigMap(configMapName, fileNameNormalized, this.getFileContent(fileName));
                propertyValue = mountPath + PropertiesUtils.SLASH + fileNameNormalized;
                if (!volumes.containsKey(mountPath)) {
                    volumes.put(propertyValue, new CustomVolume(configMapName, fileNameNormalized, CustomVolume.VolumeType.CONFIG_MAP));
                }
            } else if (this.isSecret((String)propertyValue)) {
                path = entry.getValue().replace("secret::/", "");
                mountPath = this.getMountPath(path);
                filename = this.getFileName(path);
                String secretName = this.normalizeConfigMapName(path);
                this.doCreateSecretFromFile(secretName, this.getFilePath(path));
                volumes.put(mountPath, new CustomVolume(secretName, "", CustomVolume.VolumeType.SECRET));
                propertyValue = mountPath + PropertiesUtils.SLASH + filename;
            }
            output.put(entry.getKey(), (String)propertyValue);
        }
        for (Map.Entry<String, String> entry : volumes.entrySet()) {
            dc.getSpec().getTemplate().getSpec().getVolumes().add(((CustomVolume)((Object)entry.getValue())).getVolume());
            dc.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(this.createVolumeMount(volume)));
        }
        return output;
    }

    private VolumeMount createVolumeMount(Map.Entry<String, CustomVolume> volume) {
        VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volume.getValue().getName())).withReadOnly(Boolean.valueOf(true))).withMountPath(volume.getKey());
        if (!volume.getValue().getSubFolderRegExp().isEmpty()) {
            volumeMountBuilder.withSubPathExpr(volume.getValue().getSubFolderRegExp());
        }
        return volumeMountBuilder.build();
    }

    private void createOrUpdateConfigMap(String configMapName, String key, String value) {
        MixedOperation configMaps = this.client.configMaps();
        if (((Resource)configMaps.withName(configMapName)).get() != null) {
            ((Resource)configMaps.withName(configMapName)).edit(configMap -> {
                configMap.getData().put(key, value);
                return configMap;
            });
        } else {
            ((Resource)configMaps.resource((Object)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(key, value)).build())).createOrReplace();
        }
    }

    private String getFileName(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return path;
        }
        return path.substring(path.lastIndexOf(PropertiesUtils.SLASH) + 1);
    }

    private String getMountPath(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return RESOURCE_MNT_FOLDER;
        }
        Object mountPath = (String)StringUtils.defaultIfEmpty((CharSequence)path.substring(0, path.lastIndexOf(PropertiesUtils.SLASH)), (CharSequence)RESOURCE_MNT_FOLDER);
        if (!path.startsWith(PropertiesUtils.SLASH)) {
            mountPath = PropertiesUtils.SLASH + (String)mountPath;
        }
        return mountPath;
    }

    private String getFileContent(String path) {
        String filePath = this.getFilePath(path);
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            return FileUtils.loadFile((File)Path.of(filePath, new String[0]).toFile());
        }
        return FileUtils.loadFile((String)filePath);
    }

    private String getFilePath(String path) {
        String string;
        block8: {
            Stream<Path> binariesFound = Files.find(PropertiesUtils.TARGET, Integer.MAX_VALUE, (file, basicFileAttributes) -> file.toString().contains(path), new FileVisitOption[0]);
            try {
                string = binariesFound.map(Path::toString).findFirst().orElse(path);
                if (binariesFound == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binariesFound != null) {
                        try {
                            binariesFound.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return path;
                }
            }
            binariesFound.close();
        }
        return string;
    }

    private String normalizeConfigMapName(String name) {
        return StringUtils.removeStart((String)name, (String)PropertiesUtils.SLASH).replaceAll(Pattern.quote("."), "-").replaceAll(PropertiesUtils.SLASH, "-");
    }

    private boolean isResourceWithDestinationPath(String key) {
        return key.startsWith("resource_with_destination::");
    }

    private boolean isResource(String key) {
        return key.startsWith("resource::/");
    }

    private boolean isSecret(String key) {
        return key.startsWith("secret::/");
    }

    private boolean hasImageStreamTags(ImageStream is) {
        return !((ImageStream)((Resource)this.client.imageStreams().withName(is.getMetadata().getName())).get()).getStatus().getTags().isEmpty();
    }

    private boolean isPodRunning(Pod pod) {
        return pod.getStatus().getPhase().equals("Running");
    }

    private String createProject() {
        boolean projectCreated = false;
        String namespace = this.generateRandomProjectName();
        for (int index = 0; index < 5; ++index) {
            if (this.doCreateProject(namespace)) {
                projectCreated = true;
                break;
            }
            namespace = this.generateRandomProjectName();
        }
        if (!projectCreated) {
            Assertions.fail((String)"Project cannot be created. Review your OpenShift installation.");
        }
        return namespace;
    }

    private void doCreateSecretFromFile(String name, String filePath) {
        if (((Resource)this.client.secrets().withName(name)).get() == null) {
            try {
                new Command(new String[]{OC, "create", "secret", "generic", name, "--from-file=" + filePath, "-n", this.currentNamespace}).runAndWait();
            }
            catch (Exception e) {
                Assertions.fail((String)("Could not create secret. Caused by " + e.getMessage()));
            }
        }
    }

    private boolean doCreateProject(String projectName) {
        boolean created = false;
        try {
            new Command(new String[]{OC, "new-project", projectName}).runAndWait();
            created = true;
        }
        catch (Exception e) {
            Log.warn((String)("Project " + projectName + " failed to be created. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return created;
    }

    private List<HasMetadata> loadYaml(String template) {
        NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable load = this.client.load((InputStream)new ByteArrayInputStream(template.getBytes()));
        return load.items();
    }

    private String generateRandomProjectName() {
        return ThreadLocalRandom.current().ints(10L, 97, 123).collect(() -> new StringBuilder("ts-"), StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

