/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.operator;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.OperatorService;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.operator.OperatorManagedResourceBuilder;
import io.quarkus.test.services.operator.model.CustomResourceDefinition;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OperatorManagedResource
implements ManagedResource {
    private final OperatorManagedResourceBuilder model;
    private final OpenShiftClient client;
    private boolean running;
    private List<CustomResourceDefinition> crdsToWatch = new ArrayList<CustomResourceDefinition>();

    public OperatorManagedResource(OperatorManagedResourceBuilder model) {
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    public String getDisplayName() {
        return this.model.getName();
    }

    public void start() {
        if (!this.running) {
            this.installOperator();
            this.applyCRDs();
            this.running = true;
        }
    }

    public void stop() {
    }

    public boolean isRunning() {
        return this.running && this.customResourcesAreReady();
    }

    public URILike getURI(Protocol protocol) {
        throw new UnsupportedOperationException("Operator does not expose services.");
    }

    public List<String> logs() {
        return Collections.emptyList();
    }

    private void applyCRDs() {
        if (this.model.getContext().getOwner() instanceof OperatorService) {
            OperatorService service = (OperatorService)this.model.getContext().getOwner();
            for (CustomResourceDefinition crd : service.getCrds()) {
                this.applyCRD(crd);
            }
        }
    }

    private void applyCRD(CustomResourceDefinition crd) {
        ServiceContext serviceContext = this.model.getContext();
        Path crdFileDefinition = serviceContext.getServiceFolder().resolve(crd.getName());
        String content = FileUtils.loadFile((String)crd.getFile());
        FileUtils.copyContentTo((String)content, (Path)crdFileDefinition);
        this.client.apply(crdFileDefinition);
        this.crdsToWatch.add(crd);
    }

    private boolean customResourcesAreReady() {
        return this.crdsToWatch.stream().allMatch(crd -> this.client.isCustomResourceReady(crd.getName(), crd.getType()));
    }

    private void installOperator() {
        this.client.installOperator(this.model.getContext().getOwner(), this.model.getName(), this.model.getChannel(), this.model.getSource(), this.model.getSourceNamespace());
    }
}

