/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.utils.AwaitilityUtils;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public abstract class OpenShiftQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends QuarkusManagedResource {
    private static final int EXTERNAL_PORT = 80;
    private static final int EXTERNAL_SSL_PORT = 443;
    protected final T model;
    protected final OpenShiftClient client;
    private LoggingHandler loggingHandler;
    private boolean init;
    private boolean running;
    private URILike uri;

    public OpenShiftQuarkusApplicationManagedResource(T model) {
        super(model.getContext());
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    protected abstract void doInit();

    protected abstract void doUpdate();

    public void start() {
        if (this.running) {
            return;
        }
        if (!this.init) {
            this.doInit();
            this.init = true;
        } else {
            this.doUpdate();
        }
        this.client.scaleToWhenDcReady(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.uri = null;
        this.running = false;
    }

    public URILike getURI(Protocol protocol) {
        ServiceContext context = this.model.getContext();
        boolean isServerless = this.client.isServerlessService(context.getName());
        if (protocol == Protocol.HTTPS && !isServerless) {
            Assertions.fail((String)"SSL is not supported for OpenShift tests yet");
        } else if (protocol == Protocol.GRPC) {
            Assertions.fail((String)"gRPC is not supported for OpenShift tests yet");
        } else if (protocol == Protocol.MANAGEMENT && this.model.useSeparateManagementInterface()) {
            if (this.model.useManagementSsl()) {
                Assertions.fail((String)"SSL is not supported for OpenShift tests yet");
            }
            return this.client.url(context.getOwner().getName() + "-management").withPort(80);
        }
        if (this.uri == null) {
            int port = isServerless ? 443 : 80;
            this.uri = (URILike)AwaitilityUtils.untilIsNotNull(() -> this.client.url(context.getOwner()).withPort(port), (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.defaults().withService(this.getContext().getOwner()));
        }
        return this.uri;
    }

    public boolean isRunning() {
        if (!this.running) {
            return false;
        }
        if (this.client.isServerlessService(this.model.getContext().getName())) {
            return this.routeIsReachable(Protocol.HTTPS);
        }
        return super.isRunning() && this.routeIsReachable(Protocol.HTTP);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        if (this.model.containsBuildProperties()) {
            this.init = false;
            this.model.build();
        }
        this.start();
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private boolean routeIsReachable(Protocol protocol) {
        URILike url = this.getURI(protocol);
        return ((Response)RestAssured.given().relaxedHTTPSValidation().baseUri(url.getRestAssuredStyleUri()).basePath("/").port(url.getPort()).get()).getStatusCode() != 503;
    }
}

